/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.config.SoulShardConfig;
import iskallia.vault.container.inventory.ShardTradeContainer;
import iskallia.vault.gear.VaultGearHelper;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModSounds;
import iskallia.vault.item.InscriptionItem;
import iskallia.vault.item.ItemShardPouch;
import iskallia.vault.item.gear.DataInitializationItem;
import iskallia.vault.item.gear.DataTransferItem;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.util.SidedHelper;
import iskallia.vault.world.data.PlayerBlackMarketData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkEvent;

public class ShardTradeTradeMessage {
    private final int tradeIndex;
    private final UUID uuid;
    private final boolean shift;

    public ShardTradeTradeMessage(int tradeIndex, boolean shift, UUID uuid) {
        this.tradeIndex = tradeIndex;
        this.shift = shift;
        this.uuid = uuid;
    }

    public boolean isRandom() {
        return this.tradeIndex == -1;
    }

    public static void encode(ShardTradeTradeMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.tradeIndex);
        buffer.writeBoolean(message.shift);
        buffer.m_130077_(message.uuid);
    }

    public static ShardTradeTradeMessage decode(FriendlyByteBuf buffer) {
        return new ShardTradeTradeMessage(buffer.readInt(), buffer.readBoolean(), buffer.m_130259_());
    }

    public static void handle(ShardTradeTradeMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ItemStack held;
            int shardCost;
            AbstractContainerMenu patt2266$temp;
            ServerPlayer sender = context.getSender();
            if (sender == null || !((patt2266$temp = sender.f_36096_) instanceof ShardTradeContainer)) {
                return;
            }
            ShardTradeContainer tradeContainer = (ShardTradeContainer)patt2266$temp;
            PlayerBlackMarketData tradeData = PlayerBlackMarketData.get(sender.m_183503_());
            int shardCount = ItemShardPouch.getShardCount(sender.m_150109_());
            ItemStack resultStack = null;
            if (message.isRandom()) {
                int playerLevel = PlayerVaultStatsData.get(sender.m_183503_()).getVaultStats((Player)sender).getVaultLevel();
                Set<SoulShardConfig.Trades> tradesList = ModConfigs.SOUL_SHARD.getTrades();
                SoulShardConfig.Trades tradesUsed = null;
                for (SoulShardConfig.Trades trades : tradesList) {
                    if (playerLevel < trades.getMinLevel() || tradesUsed != null && tradesUsed.getMinLevel() >= trades.getMinLevel()) continue;
                    tradesUsed = trades;
                }
                if (tradesUsed != null) {
                    if (shardCount < tradesUsed.getShardTradePrice()) {
                        return;
                    }
                    shardCost = tradesUsed.getShardTradePrice();
                    resultStack = tradesUsed.getRandomTrade().getItem().m_41777_();
                } else {
                    shardCost = 1000;
                }
            } else {
                PlayerBlackMarketData.BlackMarket.SelectedTrade trade = tradeData.getBlackMarket(message.uuid).getTrades().get(message.tradeIndex);
                if (trade == null || shardCount < trade.getShardCost()) {
                    return;
                }
                shardCost = trade.getShardCost();
                resultStack = trade.getStack().m_41777_();
            }
            if (resultStack == null || resultStack.m_41619_()) {
                return;
            }
            Item patt4206$temp = (resultStack = DataTransferItem.doConvertStack(resultStack)).m_41720_();
            if (patt4206$temp instanceof VaultGearItem) {
                VaultGearItem gearItem = (VaultGearItem)patt4206$temp;
                gearItem.setItemLevel(resultStack, (Player)sender);
                VaultGearHelper.initializeGearRollType(resultStack, sender);
            } else if (resultStack.m_41720_() instanceof InscriptionItem) {
                resultStack.m_41784_().m_128405_("level", SidedHelper.getVaultLevel((Player)sender));
            }
            DataInitializationItem.doInitialize(resultStack);
            IItemHandler playerInv = (IItemHandler)sender.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP).orElseThrow(IllegalStateException::new);
            if (!ItemShardPouch.reduceShardAmount(sender.m_150109_(), shardCost, true)) {
                return;
            }
            if (!message.shift && !(held = tradeContainer.m_142621_()).m_41619_()) {
                return;
            }
            if (ItemShardPouch.reduceShardAmount(sender.m_150109_(), shardCost, false)) {
                if (!message.isRandom()) {
                    tradeData.getBlackMarket(message.uuid).useTrade(message.tradeIndex);
                }
                if (message.shift) {
                    ItemStack remainder = MiscUtils.mergeIntoInventory(playerInv, resultStack, false);
                    if (!remainder.m_41619_()) {
                        sender.m_36176_(remainder.m_41777_(), true);
                    }
                } else {
                    held = tradeContainer.m_142621_();
                    if (held.m_41619_()) {
                        tradeContainer.m_142503_(resultStack);
                    } else {
                        held.m_41769_(resultStack.m_41613_());
                    }
                }
                tradeContainer.m_38946_();
            }
            sender.f_19853_.m_5594_(null, sender.m_142538_(), ModSounds.VAULT_CHEST_RARE_OPEN, SoundSource.PLAYERS, 1.0f, 0.5f);
            tradeData.getBlackMarket((Player)sender).syncToClient(sender.f_8924_);
        });
        context.setPacketHandled(true);
    }
}

