/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.client.particles.ShockedParticle;
import iskallia.vault.init.ModParticles;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class ShockedParticleMessage {
    private final Vec3 playerPos;
    private final Vec3 offset;
    private final int entityID;

    public ShockedParticleMessage(Vec3 playerPos, Vec3 offset, int entityID) {
        this.playerPos = playerPos;
        this.offset = offset;
        this.entityID = entityID;
    }

    public static void encode(ShockedParticleMessage message, FriendlyByteBuf buffer) {
        buffer.writeDouble(message.playerPos.f_82479_);
        buffer.writeDouble(message.playerPos.f_82480_);
        buffer.writeDouble(message.playerPos.f_82481_);
        buffer.writeDouble(message.offset.f_82479_);
        buffer.writeDouble(message.offset.f_82480_);
        buffer.writeDouble(message.offset.f_82481_);
        buffer.writeInt(message.entityID);
    }

    public static ShockedParticleMessage decode(FriendlyByteBuf buffer) {
        return new ShockedParticleMessage(new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()), new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()), buffer.readInt());
    }

    public static void handle(ShockedParticleMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (Minecraft.m_91087_().f_91073_ != null) {
                ShockedParticleMessage.spawnParticles(message.playerPos, message.offset, message.entityID);
            }
        });
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void spawnParticles(Vec3 pos, Vec3 offset, int entityID) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Random random = new Random();
        ParticleEngine pe = Minecraft.m_91087_().f_91061_;
        Entity entity = level.m_6815_(entityID);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            for (int i = 0; i < 20; ++i) {
                Particle particle = pe.m_107370_((ParticleOptions)ModParticles.SHOCKED.get(), pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), (double)Mth.m_144924_((Random)random, (float)((float)(-offset.f_82479_)), (float)((float)offset.f_82479_)), (double)Mth.m_144924_((Random)random, (float)((float)(-offset.f_82480_)), (float)((float)offset.f_82480_)), (double)Mth.m_144924_((Random)random, (float)((float)(-offset.f_82481_)), (float)((float)offset.f_82481_)));
                if (!(particle instanceof ShockedParticle)) continue;
                ShockedParticle shockedParticle = (ShockedParticle)particle;
                shockedParticle.setLivingEntity(livingEntity);
            }
        }
    }
}

