/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.block.entity.SpiritExtractorTileEntity;
import iskallia.vault.init.ModModelDiscoveryGoals;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class SpiritExtractorMessage {
    private final BlockPos extractorPos;
    private final Action action;

    public SpiritExtractorMessage(BlockPos extractorPos, Action action) {
        this.extractorPos = extractorPos;
        this.action = action;
    }

    public static void encode(SpiritExtractorMessage message, FriendlyByteBuf buffer) {
        buffer.m_130064_(message.extractorPos);
        buffer.m_130070_(message.action.toString());
    }

    public static SpiritExtractorMessage decode(FriendlyByteBuf buffer) {
        return new SpiritExtractorMessage(buffer.m_130135_(), Action.valueOf(buffer.m_130277_()));
    }

    public static void handle(SpiritExtractorMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer serverPlayer = context.getSender();
            ServerLevel serverWorld = serverPlayer.m_183503_();
            BlockEntity patt1462$temp = serverWorld.m_7702_(message.extractorPos);
            if (patt1462$temp instanceof SpiritExtractorTileEntity) {
                SpiritExtractorTileEntity spiritExtractor = (SpiritExtractorTileEntity)patt1462$temp;
                if (message.action == Action.REVIVE) {
                    int totalCost = spiritExtractor.getRecoveryCost().getTotalCost().m_41613_();
                    ModModelDiscoveryGoals.SPIRIT_EXTRACTION.onSpiritExtracted(serverPlayer, totalCost);
                    spiritExtractor.spewItems((Player)serverPlayer);
                } else if (message.action == Action.RECYCLE) {
                    spiritExtractor.recycle();
                }
            }
        });
        context.setPacketHandled(true);
    }

    public static enum Action {
        REVIVE,
        RECYCLE;

    }
}

