/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.init.ModParticles;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class StunnedParticleMessage {
    private final Vec3 playerPos;
    private final float radius;

    public StunnedParticleMessage(Vec3 playerPos, float radius) {
        this.playerPos = playerPos;
        this.radius = radius;
    }

    public static void encode(StunnedParticleMessage message, FriendlyByteBuf buffer) {
        buffer.writeDouble(message.playerPos.f_82479_);
        buffer.writeDouble(message.playerPos.f_82480_);
        buffer.writeDouble(message.playerPos.f_82481_);
        buffer.writeFloat(message.radius);
    }

    public static StunnedParticleMessage decode(FriendlyByteBuf buffer) {
        return new StunnedParticleMessage(new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()), buffer.readFloat());
    }

    public static void handle(StunnedParticleMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (Minecraft.m_91087_().f_91073_ != null) {
                StunnedParticleMessage.spawnParticles(message.playerPos, message.radius);
            }
        });
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void spawnParticles(Vec3 pos, float radius) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        level.m_6493_((ParticleOptions)ModParticles.STUNNED.get(), true, pos.m_7096_(), pos.m_7098_() + 0.25, pos.m_7094_(), (double)radius, 0.0, 0.0);
    }
}

