/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.entity.entity.ElixirOrbEntity;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class SummonElixirOrbMessage {
    private final int id;
    private final double x;
    private final double y;
    private final double z;
    private final int age;
    private final int size;

    public SummonElixirOrbMessage(ElixirOrbEntity entity) {
        this.id = entity.m_142049_();
        this.x = entity.m_20185_();
        this.y = entity.m_20186_();
        this.z = entity.m_20189_();
        this.age = entity.getAge();
        this.size = entity.getSize();
    }

    public SummonElixirOrbMessage(FriendlyByteBuf buffer) {
        this.id = buffer.m_130242_();
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.z = buffer.readDouble();
        this.age = buffer.m_130242_();
        this.size = buffer.m_130242_();
    }

    public int getId() {
        return this.id;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public int getAge() {
        return this.age;
    }

    public int getSize() {
        return this.size;
    }

    public static void encode(SummonElixirOrbMessage message, FriendlyByteBuf buffer) {
        buffer.m_130130_(message.id);
        buffer.writeDouble(message.x);
        buffer.writeDouble(message.y);
        buffer.writeDouble(message.z);
        buffer.m_130130_(message.age);
        buffer.m_130130_(message.size);
    }

    public static SummonElixirOrbMessage decode(FriendlyByteBuf buffer) {
        return new SummonElixirOrbMessage(buffer);
    }

    public static void handle(SummonElixirOrbMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> SummonElixirOrbMessage.spawnElixirOrb(message));
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void spawnElixirOrb(SummonElixirOrbMessage message) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            return;
        }
        ElixirOrbEntity entity = new ElixirOrbEntity((Level)world, message.getX(), message.getY(), message.getZ(), message.getSize(), message.getAge());
        entity.m_20167_(message.getX(), message.getY(), message.getZ());
        entity.m_146922_(0.0f);
        entity.m_146926_(0.0f);
        entity.m_20234_(message.getId());
        world.m_104627_(message.getId(), (Entity)entity);
    }
}

