/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.container.oversized.OverSizedItemStack;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class SyncOverSizedStackMessage {
    private final int containerId;
    private final int stateId;
    private final int slot;
    private final OverSizedItemStack stack;

    public SyncOverSizedStackMessage(int containerId, int stateId, int slot, ItemStack stack) {
        this.containerId = containerId;
        this.stateId = stateId;
        this.slot = slot;
        this.stack = OverSizedItemStack.of(stack);
    }

    public SyncOverSizedStackMessage(FriendlyByteBuf buf) {
        this.containerId = buf.readInt();
        this.stateId = buf.readInt();
        this.slot = buf.readInt();
        this.stack = OverSizedItemStack.read(buf);
    }

    public static void encode(SyncOverSizedStackMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.containerId);
        buffer.writeInt(message.stateId);
        buffer.writeInt(message.slot);
        message.stack.write(buffer);
    }

    public static SyncOverSizedStackMessage decode(FriendlyByteBuf buffer) {
        return new SyncOverSizedStackMessage(buffer);
    }

    public static void handle(SyncOverSizedStackMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> SyncOverSizedStackMessage.setClientStack(message));
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void setClientStack(SyncOverSizedStackMessage message) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (message.containerId == player.f_36096_.f_38840_) {
            player.f_36096_.m_182406_(message.slot, message.stateId, message.stack.overSizedStack());
        }
    }
}

