/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.client.gui.screen.summary.VaultHistoricDataScreen;
import iskallia.vault.core.net.ArrayBitBuffer;
import iskallia.vault.core.vault.stat.VaultSnapshot;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class VaultPlayerHistoricDataMessage {

    public static class S2C {
        private List<VaultSnapshot> snapshots;

        public S2C(List<VaultSnapshot> snapshots) {
            this.snapshots = snapshots;
        }

        public static void encode(S2C message, FriendlyByteBuf buffer) {
            int size = message.snapshots.size();
            buffer.writeInt(size);
            for (int i = 0; i < size; ++i) {
                ArrayBitBuffer buffer2 = ArrayBitBuffer.empty();
                message.snapshots.get(i).writeBits(buffer2);
                buffer.m_130091_(buffer2.toLongArray());
            }
        }

        public static S2C decode(FriendlyByteBuf buffer) {
            ArrayList<VaultSnapshot> snapshots = new ArrayList<VaultSnapshot>();
            int size = buffer.readInt();
            for (int i = 0; i < size; ++i) {
                ArrayBitBuffer buffer2 = ArrayBitBuffer.backing(buffer.m_178381_(), 0);
                snapshots.add(new VaultSnapshot(buffer2));
            }
            return new S2C(snapshots);
        }

        public static void handle(S2C message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> S2C.openScreen(message));
            context.setPacketHandled(true);
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void openScreen(S2C message) {
            Minecraft.m_91087_().m_91152_((Screen)new VaultHistoricDataScreen(message.snapshots, (Component)new TextComponent("Historic Data")));
        }
    }
}

