/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.core.net.ArrayBitBuffer;
import iskallia.vault.core.vault.stat.VaultSnapshot;
import iskallia.vault.util.scheduler.EndScreenScheduler;
import iskallia.vault.world.data.VaultPlayerStats;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class VaultPlayerStatsMessage {

    public static class C2S {
        private UUID vaultId;

        public C2S(UUID vaultId) {
            this.vaultId = vaultId;
        }

        public static void encode(C2S message, FriendlyByteBuf buffer) {
            buffer.m_130077_(message.vaultId);
        }

        public static C2S decode(FriendlyByteBuf buffer) {
            return new C2S(buffer.m_130259_());
        }

        public static void handle(C2S message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (context.getSender() == null) {
                    return;
                }
                VaultPlayerStats.consume(context.getSender(), message.vaultId);
            });
            context.setPacketHandled(true);
        }
    }

    public static class S2C {
        private VaultSnapshot snapshot;

        public S2C(VaultSnapshot snapshot) {
            this.snapshot = snapshot;
        }

        public static void encode(S2C message, FriendlyByteBuf buffer) {
            ArrayBitBuffer buffer2 = ArrayBitBuffer.empty();
            message.snapshot.writeBits(buffer2);
            buffer.m_130091_(buffer2.toLongArray());
        }

        public static S2C decode(FriendlyByteBuf buffer) {
            ArrayBitBuffer buffer2 = ArrayBitBuffer.backing(buffer.m_178381_(), 0);
            return new S2C(new VaultSnapshot(buffer2));
        }

        public static void handle(S2C message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> S2C.openEndScreen(message));
            context.setPacketHandled(true);
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void openEndScreen(S2C message) {
            EndScreenScheduler.getInstance().snapshot = message.snapshot;
        }
    }
}

