/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.init.ModGameRules;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.research.ResearchTree;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class VaultResearchPenaltyMessage {

    public static class C2S {
        public static void encode(C2S message, FriendlyByteBuf buffer) {
        }

        public static C2S decode(FriendlyByteBuf buffer) {
            return new C2S();
        }

        public static void handle(C2S message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            boolean gamerule = context.getSender().m_20194_().m_129900_().m_46207_(ModGameRules.NO_RESEARCH_TEAM_PENALTY);
            ModNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> ((NetworkEvent.Context)context).getSender()), (Object)new S2C(gamerule));
            ResearchTree.setResearchGamerule(gamerule);
            context.setPacketHandled(true);
        }
    }

    public static class S2C {
        private boolean isPenalty;

        public S2C(boolean pen) {
            this.isPenalty = pen;
        }

        public static void encode(S2C message, FriendlyByteBuf buffer) {
            buffer.writeBoolean(message.isPenalty);
        }

        public static S2C decode(FriendlyByteBuf buffer) {
            return new S2C(buffer.readBoolean());
        }

        public static void handle(S2C message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> S2C.handleClient(message.isPenalty)));
            context.setPacketHandled(true);
        }

        public static void handleClient(boolean isPenalty) {
            ResearchTree.setResearchGamerule(isPenalty);
        }
    }
}

