/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.init.ModParticles;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class WendarrSparkParticleMessage {
    private final Vec3 playerPos;

    public WendarrSparkParticleMessage(Vec3 playerPos) {
        this.playerPos = playerPos;
    }

    public static void encode(WendarrSparkParticleMessage message, FriendlyByteBuf buffer) {
        buffer.writeDouble(message.playerPos.f_82479_);
        buffer.writeDouble(message.playerPos.f_82480_);
        buffer.writeDouble(message.playerPos.f_82481_);
    }

    public static WendarrSparkParticleMessage decode(FriendlyByteBuf buffer) {
        return new WendarrSparkParticleMessage(new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()));
    }

    public static void handle(WendarrSparkParticleMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (Minecraft.m_91087_().f_91073_ != null) {
                WendarrSparkParticleMessage.spawnParticles(message.playerPos);
            }
        });
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void spawnParticles(Vec3 pos) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Random random = new Random();
        for (int i = 0; i < 70; ++i) {
            float rotation = random.nextFloat() * 360.0f;
            float radiusOffset = random.nextFloat() + 0.5f;
            Vec3 offset = new Vec3((double)(radiusOffset / 5.0f) * Math.cos(rotation), 0.0, (double)(radiusOffset / 5.0f) * Math.sin(rotation));
            level.m_6493_((ParticleOptions)ModParticles.WENDARR_SPARK_EXPLODE.get(), true, pos.m_7096_() + offset.f_82479_, pos.m_7098_() + random.nextDouble() * (double)0.15f, pos.m_7094_() + offset.f_82481_, offset.f_82479_ / 8.0, random.nextDouble() * 0.025, offset.f_82481_ / 8.0);
        }
    }
}

