/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message.bounty;

import iskallia.vault.bounty.Bounty;
import iskallia.vault.bounty.BountyList;
import iskallia.vault.bounty.client.ClientBountyData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public record ClientboundBountyProgressMessage(List<Bounty> bounties) {
    public static void encode(ClientboundBountyProgressMessage message, FriendlyByteBuf buffer) {
        if (message.bounties != null && !message.bounties.isEmpty()) {
            buffer.m_178352_(message.bounties, (friendlyByteBuf, bounty) -> friendlyByteBuf.m_130079_(bounty.serializeNBT()));
        }
    }

    public static ClientboundBountyProgressMessage decode(FriendlyByteBuf buffer) {
        try {
            List bountyList = (List)buffer.m_178371_(ArrayList::new, friendlyByteBuf -> new Bounty(friendlyByteBuf.m_130260_()));
            return new ClientboundBountyProgressMessage(bountyList);
        }
        catch (Exception ex) {
            return new ClientboundBountyProgressMessage(null);
        }
    }

    public static void handle(ClientboundBountyProgressMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        BountyList bounties = new BountyList();
        List<Bounty> bountiesSent = message.bounties;
        if (bountiesSent != null && !bountiesSent.isEmpty()) {
            bounties.addAll(bountiesSent);
        }
        ClientBountyData.INSTANCE.updateBounties(bounties);
        context.setPacketHandled(true);
    }
}

