/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message.transmog;

import iskallia.vault.client.ClientDiscoveredEntriesData;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public record DiscoveredEntriesMessage(Type type, Set<ResourceLocation> discoveredEntries) {
    public static void encode(DiscoveredEntriesMessage message, FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)message.type);
        buffer.writeInt(message.discoveredEntries.size());
        message.discoveredEntries.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130085_(arg_0));
    }

    public static DiscoveredEntriesMessage decode(FriendlyByteBuf buffer) {
        Type type = (Type)buffer.m_130066_(Type.class);
        int size = buffer.readInt();
        HashSet<ResourceLocation> ids = new HashSet<ResourceLocation>();
        for (int i = 0; i < size; ++i) {
            ids.add(buffer.m_130281_());
        }
        return new DiscoveredEntriesMessage(type, ids);
    }

    public static void handle(DiscoveredEntriesMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> ClientDiscoveredEntriesData.receiveMessage(message));
        context.setPacketHandled(true);
    }

    public static enum Type {
        MODELS,
        TRINKETS;

    }
}

