/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.quest.base;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.Expose;
import iskallia.vault.config.entry.DescriptionData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.item.gear.DataInitializationItem;
import iskallia.vault.item.gear.DataTransferItem;
import iskallia.vault.quest.QuestState;
import iskallia.vault.quest.type.AnvilQuest;
import iskallia.vault.quest.type.BlockInteractionQuest;
import iskallia.vault.quest.type.BountyCompleteQuest;
import iskallia.vault.quest.type.CheckmarkQuest;
import iskallia.vault.quest.type.CollectionQuest;
import iskallia.vault.quest.type.CraftCrystalQuest;
import iskallia.vault.quest.type.CraftingQuest;
import iskallia.vault.quest.type.EnterVaultQuest;
import iskallia.vault.quest.type.ForgeGearQuest;
import iskallia.vault.quest.type.LevelUpQuest;
import iskallia.vault.quest.type.MiningQuest;
import iskallia.vault.quest.type.ModifyGearQuest;
import iskallia.vault.quest.type.SurviveQuest;
import iskallia.vault.util.EntityHelper;
import iskallia.vault.world.data.PlayerVaultStatsData;
import iskallia.vault.world.data.QuestStatesData;
import java.lang.reflect.Type;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class Quest
implements Comparable<Quest> {
    @Expose
    protected final String type;
    @Expose
    protected final String id;
    @Expose
    protected final String name;
    @Expose
    protected final DescriptionData descriptionData;
    @Expose
    protected final ResourceLocation icon;
    @Expose
    protected final ResourceLocation targetId;
    @Expose
    protected final float targetProgress;
    @Expose
    protected final String unlockedBy;
    @Expose
    protected final QuestReward reward;

    protected Quest(String type, String id, String name, DescriptionData descriptionData, ResourceLocation icon, ResourceLocation targetId, float targetProgress, String unlockedBy, QuestReward reward) {
        this.type = type;
        this.id = id;
        this.name = name;
        this.descriptionData = descriptionData;
        this.icon = icon;
        this.targetId = targetId;
        this.targetProgress = targetProgress;
        this.unlockedBy = unlockedBy;
        this.reward = reward;
    }

    public String getType() {
        return this.type;
    }

    public abstract MutableComponent getTypeDescription();

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public MutableComponent getDescription() {
        if (this.descriptionData == null) {
            return Component.Serializer.m_130714_((String)("[{text:'No description for ', color:'#192022'},{text: '" + this.id + "', color: '#fcf5c5'},{text: ', yet', color: '#192022'}]"));
        }
        return Component.Serializer.m_130691_((JsonElement)this.descriptionData.getDescription());
    }

    public JsonElement getDescriptionElement() {
        return this.descriptionData.getDescription();
    }

    public ResourceLocation getIcon() {
        return this.icon;
    }

    public ResourceLocation getTargetId() {
        return this.targetId;
    }

    public float getTargetProgress() {
        return this.targetProgress;
    }

    public String getUnlockedBy() {
        return this.unlockedBy;
    }

    public QuestReward getReward() {
        return this.reward;
    }

    public void progress(ServerPlayer player, float amount) {
        QuestStatesData data = QuestStatesData.get();
        QuestState state = data.getState(player);
        state.addProgress(this, amount);
        data.m_77762_();
    }

    public void onComplete(ServerPlayer player) {
        if (this.reward != null) {
            this.reward.apply(player);
        }
    }

    @Override
    public int compareTo(@NotNull Quest other) {
        if (this.id.equals(other.id)) {
            return 0;
        }
        if (this.unlockedBy.isBlank()) {
            return -1;
        }
        if (this.unlockedBy.equals(other.id)) {
            return 1;
        }
        if (this.id.equals(other.unlockedBy)) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return "Quest{type='" + this.type + "', id='" + this.id + "', unlockedBy='" + this.unlockedBy + "'}";
    }

    public static class QuestReward {
        @Expose
        List<ItemStack> items;
        @Expose
        int vaultExp;
        @Expose
        int skillPoints;

        public QuestReward(List<ItemStack> items, int vaultExp) {
            this.items = items;
            this.vaultExp = vaultExp;
            this.skillPoints = 0;
        }

        public QuestReward(List<ItemStack> items, int vaultExp, int skillPoints) {
            this.items = items;
            this.vaultExp = vaultExp;
            this.skillPoints = skillPoints;
        }

        public void apply(ServerPlayer player) {
            PlayerVaultStatsData data = PlayerVaultStatsData.get(player.m_183503_());
            int vaultLevel = data.getVaultStats((Player)player).getVaultLevel();
            this.getItems().forEach(stack -> {
                Item patt4485$temp = stack.m_41720_();
                if (patt4485$temp instanceof VaultGearItem) {
                    VaultGearItem gearItem = (VaultGearItem)patt4485$temp;
                    gearItem.setItemLevel((ItemStack)stack, vaultLevel);
                }
                stack = DataTransferItem.doConvertStack(stack);
                DataInitializationItem.doInitialize(stack);
                EntityHelper.giveItem((Player)player, stack);
            });
            data.addVaultExp(player, this.vaultExp);
            data.addSkillPoints(player, this.skillPoints);
        }

        public int getVaultExp() {
            return this.vaultExp;
        }

        public List<ItemStack> getItems() {
            return this.items.stream().map(ItemStack::m_41777_).toList();
        }

        public int getSkillPoints() {
            return this.skillPoints;
        }
    }

    public static class Builder {
        private String type;
        private String id;
        private String name;
        private DescriptionData descriptionData;
        private ResourceLocation icon;
        private ResourceLocation targetId;
        private float targetProgress;
        private String unlockedBy;
        private QuestReward reward;

        public Builder(String type) {
            this.type = type;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder descriptionData(DescriptionData descriptionData) {
            this.descriptionData = descriptionData;
            return this;
        }

        public Builder icon(ResourceLocation icon) {
            this.icon = icon;
            return this;
        }

        public Builder targetId(ResourceLocation targetId) {
            this.targetId = targetId;
            return this;
        }

        public Builder targetProgress(float targetProgress) {
            this.targetProgress = targetProgress;
            return this;
        }

        public Builder unlockedBy(String unlockedBy) {
            this.unlockedBy = unlockedBy;
            return this;
        }

        public Builder reward(QuestReward reward) {
            this.reward = reward;
            return this;
        }

        public Quest build() {
            if (this.id == null || this.id.isBlank()) {
                throw new IllegalStateException("Attempted to create a Quest with invalid ID. ID must not be null or empty.");
            }
            if (this.name == null || this.name.isBlank()) {
                throw new IllegalStateException("Attempted to create a Quest with invalid NAME. NAME must not be null or empty.");
            }
            if (this.descriptionData == null) {
                throw new IllegalStateException("Attempted to create a Quest with invalid DESCRIPTION. DESCRIPTION must not be null or empty.");
            }
            if (this.icon == null) {
                throw new IllegalStateException("Attempted to create a Quest with invalid ICON. ICON must not be null.");
            }
            if (this.targetId == null) {
                throw new IllegalStateException("Attempted to create a Quest with invalid TARGET. TARGET must not be null.");
            }
            if (this.targetProgress < 1.0f) {
                throw new IllegalStateException("Attempted to create a Quest with invalid TARGET PROGRESS. Must be greater than 0.");
            }
            if (this.reward == null) {
                throw new IllegalStateException("Attempted to create a Quest with invalid REWARD. REWARD must not be null.");
            }
            switch (this.type) {
                case "anvil": {
                    return new AnvilQuest(this.id, this.name, this.descriptionData, this.icon, this.targetId, this.targetProgress, this.unlockedBy, this.reward);
                }
                case "block_interact": {
                    return new BlockInteractionQuest(this.id, this.name, this.descriptionData, this.icon, this.targetId, this.targetProgress, this.unlockedBy, this.reward);
                }
                case "bounty_complete": {
                    return new BountyCompleteQuest(this.id, this.name, this.descriptionData, this.icon, this.targetId, this.targetProgress, this.unlockedBy, this.reward);
                }
                case "checkmark": {
                    return new CheckmarkQuest(this.id, this.name, this.descriptionData, this.icon, this.targetId, this.targetProgress, this.unlockedBy, this.reward);
                }
                case "collection": {
                    return new CollectionQuest(this.id, this.name, this.descriptionData, this.icon, this.targetId, this.targetProgress, this.unlockedBy, this.reward);
                }
                case "craft_crystal": {
                    return new CraftCrystalQuest(this.id, this.name, this.descriptionData, this.icon, this.targetId, this.targetProgress, this.unlockedBy, this.reward);
                }
                case "crafting": {
                    return new CraftingQuest(this.id, this.name, this.descriptionData, this.icon, this.targetId, this.targetProgress, this.unlockedBy, this.reward);
                }
                case "enter_vault": {
                    return new EnterVaultQuest(this.id, this.name, this.descriptionData, this.icon, this.targetId, this.targetProgress, this.unlockedBy, this.reward);
                }
                case "forge_gear": {
                    return new ForgeGearQuest(this.id, this.name, this.descriptionData, this.icon, this.targetId, this.targetProgress, this.unlockedBy, this.reward);
                }
                case "level_up": {
                    return new LevelUpQuest(this.id, this.name, this.descriptionData, this.icon, this.targetId, this.targetProgress, this.unlockedBy, this.reward);
                }
                case "mining": {
                    return new MiningQuest(this.id, this.name, this.descriptionData, this.icon, this.targetId, this.targetProgress, this.unlockedBy, this.reward);
                }
                case "modify_gear": {
                    return new ModifyGearQuest(this.id, this.name, this.descriptionData, this.icon, this.targetId, this.targetProgress, this.unlockedBy, this.reward);
                }
                case "survive": {
                    return new SurviveQuest(this.id, this.name, this.descriptionData, this.icon, this.targetId, this.targetProgress, this.unlockedBy, this.reward);
                }
            }
            return null;
        }
    }

    public static class Adapter
    implements JsonDeserializer<Quest> {
        public static final Adapter INSTANCE = new Adapter();

        public Quest deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            String type = object.get("type").getAsString();
            String id = object.get("id").getAsString();
            String name = object.get("name").getAsString();
            DescriptionData descriptionData = (DescriptionData)context.deserialize(object.get("descriptionData"), DescriptionData.class);
            ResourceLocation icon = new ResourceLocation(object.get("icon").getAsString());
            ResourceLocation targetId = new ResourceLocation(object.get("targetId").getAsString());
            float targetProgress = object.get("targetProgress").getAsFloat();
            String unlockedBy = object.has("unlockedBy") ? object.get("unlockedBy").getAsString() : "";
            QuestReward questReward = (QuestReward)context.deserialize(object.get("reward"), QuestReward.class);
            Builder builder = new Builder(type).id(id).name(name).descriptionData(descriptionData).icon(icon).targetId(targetId).targetProgress(targetProgress).unlockedBy(unlockedBy).reward(questReward);
            return builder.build();
        }
    }
}

