/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.quest.type;

import iskallia.vault.config.entry.DescriptionData;
import iskallia.vault.quest.base.Quest;
import iskallia.vault.world.data.QuestStatesData;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class AnvilQuest
extends Quest {
    public static final String ANVIL = "anvil";

    public AnvilQuest(String id, String name, DescriptionData descriptionData, ResourceLocation icon, ResourceLocation targetId, float targetProgress, String unlockedBy, Quest.QuestReward reward) {
        super(ANVIL, id, name, descriptionData, icon, targetId, targetProgress, unlockedBy, reward);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onAnvilCombine(AnvilRepairEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (!QuestStatesData.get().getState(player2).getInProgress().contains((Object)this.id)) {
            return;
        }
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)event.getIngredientInput().m_41720_());
        if (itemId != null && itemId.equals((Object)this.targetId)) {
            this.progress(player2, event.getIngredientInput().m_41613_());
        }
    }

    @Override
    public MutableComponent getTypeDescription() {
        return new TextComponent("Combine items in an anvil.");
    }
}

