/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.quest.type;

import iskallia.vault.config.entry.DescriptionData;
import iskallia.vault.quest.base.Quest;
import iskallia.vault.util.InventoryUtil;
import iskallia.vault.world.data.QuestStatesData;
import java.util.List;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class CollectionQuest
extends Quest {
    public static final String COLLECTION = "collection";

    public CollectionQuest(String id, String name, DescriptionData descriptionData, ResourceLocation icon, ResourceLocation targetId, float targetProgress, String unlockedBy, Quest.QuestReward reward) {
        super(COLLECTION, id, name, descriptionData, icon, targetId, targetProgress, unlockedBy, reward);
    }

    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (player2.f_19797_ % 20 == 0) {
            this.queryCollection(player2);
        }
    }

    public void queryCollection(ServerPlayer player) {
        if (!QuestStatesData.get().getState(player).getInProgress().contains((Object)this.id)) {
            return;
        }
        Item targetItem = (Item)ForgeRegistries.ITEMS.getValue(this.targetId);
        if (targetItem == null) {
            return;
        }
        List<ItemStack> items = InventoryUtil.findAllItems((Player)player).stream().map(InventoryUtil.ItemAccess::getStack).filter(stack -> stack.m_41720_() == targetItem).toList();
        int heldAmount = 0;
        for (ItemStack stack2 : items) {
            heldAmount += stack2.m_41613_();
        }
        if ((float)heldAmount >= this.targetProgress) {
            this.progress(player, heldAmount);
        }
    }

    @Override
    public MutableComponent getTypeDescription() {
        return new TextComponent("Collect the item(s). When clicking 'Complete', the items must be in your inventory and are not consumed.");
    }
}

