/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.quest.type;

import iskallia.vault.config.entry.DescriptionData;
import iskallia.vault.quest.base.Quest;
import iskallia.vault.world.data.QuestStatesData;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class MiningQuest
extends Quest {
    public static final String MINING = "mining";

    public MiningQuest(String id, String name, DescriptionData descriptionData, ResourceLocation icon, ResourceLocation targetId, float targetProgress, String unlockedBy, Quest.QuestReward reward) {
        super(MINING, id, name, descriptionData, icon, targetId, targetProgress, unlockedBy, reward);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onBreakBlock(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (!QuestStatesData.get().getState(player2).getInProgress().contains((Object)this.id)) {
            return;
        }
        Block targetBlock = (Block)ForgeRegistries.BLOCKS.getValue(this.targetId);
        if (targetBlock == null) {
            return;
        }
        Block mined = event.getState().m_60734_();
        if (mined == targetBlock) {
            this.progress(player2, 1.0f);
        }
    }

    @Override
    public MutableComponent getTypeDescription() {
        return new TextComponent("Mine the block.");
    }
}

