/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.research;

import iskallia.vault.research.ResearchTree;
import iskallia.vault.research.Restrictions;
import iskallia.vault.util.SideOnlyFixer;
import iskallia.vault.world.data.PlayerResearchesData;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="the_vault")
public class StageManager {
    public static ResearchTree RESEARCH_TREE = ResearchTree.empty();

    public static ResearchTree getResearchTree(Player player) {
        ResearchTree researchTree = ResearchTree.empty();
        if (player instanceof FakePlayer) {
            researchTree = PlayerResearchesData.get((ServerLevel)player.f_19853_).getResearches(player);
        } else {
            if (player.f_19853_.f_46443_) {
                return RESEARCH_TREE;
            }
            researchTree = PlayerResearchesData.get((ServerLevel)player.f_19853_).getResearches(player);
        }
        return researchTree;
    }

    private static void warnResearchRequirement(String researchName, String i18nKey) {
        TextComponent name = new TextComponent(researchName);
        Style style = Style.f_131099_.m_131148_(TextColor.m_131266_((int)-203978));
        name.m_6270_(style);
        TranslatableComponent text = new TranslatableComponent("overlay.requires_research." + i18nKey, new Object[]{name});
        Minecraft.m_91087_().f_91065_.m_93063_((Component)text, false);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        Player player = event.getPlayer();
        if (player.m_7500_()) {
            return;
        }
        ResearchTree researchTree = StageManager.getResearchTree(player);
        ItemStack craftedItemStack = event.getCrafting();
        Container craftingMatrix = event.getInventory();
        String restrictedBy = researchTree.restrictedBy(craftedItemStack, Restrictions.Type.CRAFTABILITY);
        if (restrictedBy == null) {
            return;
        }
        if (event.getPlayer().f_19853_.f_46443_) {
            StageManager.warnResearchRequirement(restrictedBy, "craft");
        }
        for (int i = 0; i < craftingMatrix.m_6643_(); ++i) {
            ItemStack itemStack = craftingMatrix.m_8020_(i);
            if (itemStack == ItemStack.f_41583_) continue;
            ItemStack itemStackToDrop = itemStack.m_41777_();
            itemStackToDrop.m_41764_(1);
            player.m_7197_(itemStackToDrop, false, false);
        }
        int slot = SideOnlyFixer.getSlotFor(player.m_150109_(), craftedItemStack);
        if (slot != -1) {
            ItemStack stackInSlot = player.m_150109_().m_8020_(slot);
            if (stackInSlot.m_41613_() < craftedItemStack.m_41613_()) {
                craftedItemStack.m_41764_(stackInSlot.m_41613_());
            }
            stackInSlot.m_41774_(craftedItemStack.m_41613_());
        } else {
            craftedItemStack.m_41774_(craftedItemStack.m_41613_());
        }
    }

    @SubscribeEvent
    public static void onItemUse(PlayerInteractEvent.RightClickItem event) {
        if (!event.isCancelable()) {
            return;
        }
        Player player = event.getPlayer();
        if (player.m_7500_()) {
            return;
        }
        ResearchTree researchTree = StageManager.getResearchTree(player);
        Item usedItem = event.getItemStack().m_41720_();
        String restrictedBy = researchTree.restrictedBy(event.getItemStack(), Restrictions.Type.USABILITY);
        if (restrictedBy == null) {
            return;
        }
        if (event.getSide() == LogicalSide.CLIENT) {
            StageManager.warnResearchRequirement(restrictedBy, "usage");
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onRightClickEmpty(PlayerInteractEvent.RightClickEmpty event) {
        if (!event.isCancelable()) {
            return;
        }
        Player player = event.getPlayer();
        if (player.m_7500_()) {
            return;
        }
        ResearchTree researchTree = StageManager.getResearchTree(player);
        Item usedItem = event.getItemStack().m_41720_();
        String restrictedBy = researchTree.restrictedBy(event.getItemStack(), Restrictions.Type.USABILITY);
        if (restrictedBy == null) {
            return;
        }
        if (event.getSide() == LogicalSide.CLIENT) {
            StageManager.warnResearchRequirement(restrictedBy, "usage");
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onBlockInteraction(PlayerInteractEvent.RightClickBlock event) {
        BlockState blockState;
        if (!event.isCancelable()) {
            return;
        }
        Player player = event.getPlayer();
        if (player.m_7500_()) {
            return;
        }
        ResearchTree researchTree = StageManager.getResearchTree(player);
        String restrictedBy = researchTree.restrictedBy((blockState = player.f_19853_.m_8055_(event.getPos())).m_60734_(), Restrictions.Type.BLOCK_INTERACTABILITY);
        if (restrictedBy != null) {
            if (event.getSide() == LogicalSide.CLIENT) {
                StageManager.warnResearchRequirement(restrictedBy, "interact_block");
            }
            event.setCanceled(true);
            return;
        }
        ItemStack itemStack = event.getItemStack();
        if (itemStack == ItemStack.f_41583_) {
            return;
        }
        restrictedBy = researchTree.restrictedBy(itemStack, Restrictions.Type.USABILITY);
        if (restrictedBy != null) {
            if (event.getSide() == LogicalSide.CLIENT) {
                StageManager.warnResearchRequirement(restrictedBy, "usage");
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockHit(PlayerInteractEvent.LeftClickBlock event) {
        BlockState blockState;
        if (!event.isCancelable()) {
            return;
        }
        Player player = event.getPlayer();
        if (player.m_7500_()) {
            return;
        }
        ResearchTree researchTree = StageManager.getResearchTree(player);
        String restrictedBy = researchTree.restrictedBy((blockState = player.f_19853_.m_8055_(event.getPos())).m_60734_(), Restrictions.Type.HITTABILITY);
        if (restrictedBy != null) {
            if (event.getSide() == LogicalSide.CLIENT) {
                StageManager.warnResearchRequirement(restrictedBy, "hit");
            }
            event.setCanceled(true);
            return;
        }
        ItemStack itemStack = event.getItemStack();
        if (itemStack == ItemStack.f_41583_) {
            return;
        }
        restrictedBy = researchTree.restrictedBy(itemStack, Restrictions.Type.USABILITY);
        if (restrictedBy != null) {
            if (event.getSide() == LogicalSide.CLIENT) {
                StageManager.warnResearchRequirement(restrictedBy, "usage");
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityInteraction(PlayerInteractEvent.EntityInteract event) {
        Entity entity;
        if (!event.isCancelable()) {
            return;
        }
        Player player = event.getPlayer();
        if (player.m_7500_()) {
            return;
        }
        ResearchTree researchTree = StageManager.getResearchTree(player);
        String restrictedBy = researchTree.restrictedBy((entity = event.getEntity()).m_6095_(), Restrictions.Type.ENTITY_INTERACTABILITY);
        if (restrictedBy != null) {
            if (event.getSide() == LogicalSide.CLIENT) {
                StageManager.warnResearchRequirement(restrictedBy, "interact_entity");
            }
            event.setCanceled(true);
            return;
        }
        ItemStack itemStack = event.getItemStack();
        if (itemStack == ItemStack.f_41583_) {
            return;
        }
        restrictedBy = researchTree.restrictedBy(itemStack, Restrictions.Type.USABILITY);
        if (restrictedBy != null) {
            if (event.getSide() == LogicalSide.CLIENT) {
                StageManager.warnResearchRequirement(restrictedBy, "usage");
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerAttack(AttackEntityEvent event) {
        Entity entity;
        if (!event.isCancelable()) {
            return;
        }
        Player player = event.getPlayer();
        if (player.m_7500_()) {
            return;
        }
        ResearchTree researchTree = StageManager.getResearchTree(player);
        String restrictedBy = researchTree.restrictedBy((entity = event.getEntity()).m_6095_(), Restrictions.Type.ENTITY_INTERACTABILITY);
        if (restrictedBy != null) {
            if (player.f_19853_.f_46443_) {
                StageManager.warnResearchRequirement(restrictedBy, "interact_entity");
            }
            event.setCanceled(true);
            return;
        }
        ItemStack itemStack = player.m_21205_();
        if (itemStack == ItemStack.f_41583_) {
            return;
        }
        restrictedBy = researchTree.restrictedBy(itemStack, Restrictions.Type.USABILITY);
        if (restrictedBy != null) {
            if (player.f_19853_.f_46443_) {
                StageManager.warnResearchRequirement(restrictedBy, "usage");
            }
            event.setCanceled(true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onItemTooltip(ItemTooltipEvent event) {
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        ResearchTree researchTree = StageManager.getResearchTree(player);
        String restrictionCausedBy = Arrays.stream(Restrictions.Type.values()).map(type -> researchTree.restrictedBy(event.getItemStack(), (Restrictions.Type)((Object)type))).filter(Objects::nonNull).findFirst().orElseGet(() -> null);
        if (restrictionCausedBy == null) {
            return;
        }
        List toolTip = event.getToolTip();
        Style textStyle = Style.f_131099_.m_131148_(TextColor.m_131266_((int)-5723992));
        Style style = Style.f_131099_.m_131148_(TextColor.m_131266_((int)-203978));
        TranslatableComponent text = new TranslatableComponent("tooltip.requires_research");
        TextComponent name = new TextComponent(" " + restrictionCausedBy);
        text.m_6270_(textStyle);
        name.m_6270_(style);
        toolTip.add(new TextComponent(""));
        toolTip.add(text);
        toolTip.add(name);
    }
}

