/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.research.type;

import com.google.gson.annotations.Expose;
import iskallia.vault.core.world.data.item.ItemPredicate;
import iskallia.vault.research.Restrictions;
import iskallia.vault.research.type.Research;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public class CustomResearch
extends Research {
    @Expose
    protected Map<ItemPredicate, Restrictions> itemRestrictions = new HashMap<ItemPredicate, Restrictions>();
    @Expose
    protected Map<String, Restrictions> blockRestrictions = new HashMap<String, Restrictions>();
    @Expose
    protected Map<String, Restrictions> entityRestrictions = new HashMap<String, Restrictions>();

    public CustomResearch(String name, int cost) {
        super(name, cost);
    }

    public Map<ItemPredicate, Restrictions> getItemRestrictions() {
        return this.itemRestrictions;
    }

    public Map<String, Restrictions> getBlockRestrictions() {
        return this.blockRestrictions;
    }

    public Map<String, Restrictions> getEntityRestrictions() {
        return this.entityRestrictions;
    }

    @Override
    public boolean restricts(ItemStack stack, Restrictions.Type restrictionType) {
        for (Map.Entry<ItemPredicate, Restrictions> entry : this.itemRestrictions.entrySet()) {
            if (!entry.getKey().test(stack)) continue;
            return entry.getValue().restricts(restrictionType);
        }
        return false;
    }

    @Override
    public boolean restricts(Block block, Restrictions.Type restrictionType) {
        ResourceLocation registryName = block.getRegistryName();
        if (registryName == null) {
            return false;
        }
        String sid = registryName.m_135827_() + ":" + registryName.m_135815_();
        Restrictions restrictions = this.blockRestrictions.get(sid);
        if (restrictions == null) {
            return false;
        }
        return restrictions.restricts(restrictionType);
    }

    @Override
    public boolean restricts(EntityType<?> entityType, Restrictions.Type restrictionType) {
        ResourceLocation registryName = entityType.getRegistryName();
        if (registryName == null) {
            return false;
        }
        String sid = registryName.m_135827_() + ":" + registryName.m_135815_();
        Restrictions restrictions = this.entityRestrictions.get(sid);
        if (restrictions == null) {
            return false;
        }
        return restrictions.restricts(restrictionType);
    }
}

