/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.component;

import iskallia.vault.init.ModConfigs;
import iskallia.vault.skill.ability.component.AbilityLabelContext;
import iskallia.vault.skill.ability.component.AbilityLabelFactory;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.TieredSkill;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;

public final class AbilityDescriptionFactory {
    public static MutableComponent create(TieredSkill skill, int tier, int maxTier, int vaultLevel) {
        List<String> keys;
        MutableComponent component = ModConfigs.ABILITIES_DESCRIPTIONS.getDescriptionFor(skill.getId());
        if (tier > 0) {
            keys = ModConfigs.ABILITIES_DESCRIPTIONS.getCurrent(skill.getId());
            AbilityDescriptionFactory.appendLabels(component, keys, "\n\nCurrent", new AbilityLabelContext<LearnableSkill>(skill.getChild(tier), vaultLevel));
        }
        if (tier < maxTier) {
            keys = ModConfigs.ABILITIES_DESCRIPTIONS.getNext(skill.getId());
            AbilityDescriptionFactory.appendLabels(component, keys, "\n\nNext", new AbilityLabelContext<LearnableSkill>(skill.getChild(tier + 1), vaultLevel));
        }
        return component;
    }

    private static void appendLabels(MutableComponent component, List<String> keys, String header, AbilityLabelContext<?> context) {
        if (!keys.isEmpty()) {
            component.m_7220_((Component)new TextComponent(header).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true))));
            for (String key : keys) {
                component.m_7220_((Component)AbilityLabelFactory.create(key, context));
            }
        }
    }

    private AbilityDescriptionFactory() {
    }
}

