/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.component;

import iskallia.vault.init.ModConfigs;
import iskallia.vault.skill.ability.component.AbilityLabelBindingRegistry;
import iskallia.vault.skill.ability.component.AbilityLabelContext;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.util.calc.AbilityPowerHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;

public final class AbilityLabelFactory {
    public static final String COOLDOWN = "cooldown";
    public static final String MANA_COST = "manaCost";
    public static final String MANA_COST_PER_SECOND = "manaCostPerSecond";
    public static final String LEVEL = "level";
    public static final String DISTANCE = "distance";
    public static final String DAMAGE = "damage";
    public static final String ABILITY_POWER = "ability_power";
    public static final String DURATION = "duration";
    public static final String DELAY = "delay";
    public static final String RANGE_HORIZONTAL = "rangeHorizontal";
    public static final String RANGE_VERTICAL = "rangeVertical";
    public static final String CHANCE = "chance";
    public static final String HEAL = "heal";
    public static final String RADIUS = "radius";
    public static final String ABSORB = "absorb";
    public static final String MANA_PER_DAMAGE = "manaPerDamage";
    public static final String KNOCKBACK = "knockback";
    public static final String SLOWNESS = "slowness";
    public static final String CHILLED = "chilled";
    public static final String CHAINS = "chains";
    public static final String LEECH = "leech";
    public static final String ETERNALS = "eternals";
    public static final String ANCIENT_CHANCE = "ancientChance";
    public static final String RESISTANCE = "resistance";
    public static final String SPEED = "speed";
    public static final String DURABILITY_WEAR_REDUCTION = "durabilityWearReduction";
    public static final String RESISTANCE_KNOCKBACK = "resistanceKnockback";
    public static final String REDUCED_PROJECTILE_DAMAGE_TAKEN = "reducedProjectileDamageTaken";
    public static final String BLOCKS = "blocks";
    public static final String UNBREAKING = "unbreaking";
    public static final String FORTUNE = "fortune";
    public static final String MANA_REGEN = "manaRegen";
    public static final String MAX_TARGETS = "maxTargets";
    public static final String DAMAGE_REDUCTION = "damageReduction";
    public static final String FREEZE_DURATION = "freezeDuration";
    public static final String DAMAGE_INCREASE = "damageIncrease";
    public static final String DAMAGE_INTERVAL = "damageInterval";
    public static final String PIERCING = "piercing";
    public static final String NUMBER_OF_BOUNCES = "numberOfBounces";
    public static final String NUMBER_OF_JAVELINS = "numberOfJavelins";
    public static final String THROW_POWER = "throwPower";
    public static final String AMPLIFIER = "amplifier";
    public static final String MANA_PER_BOLT = "additionalManaPerBolt";
    public static final String FORCE = "force";
    public static final String MANA_PER_HIT = "additionalManaPerHit";
    public static final String STUN_CHANCE = "stunChance";
    public static final String STUN_DURATION = "stunDuration";
    public static final String STUN_AMPLIFIER = "stunAmplifier";
    public static final String QUILL_COUNT = "quillCount";
    public static final String STORM_INTERVAL = "stormInterval";
    public static final String SLOW_DURATION = "slowDuration";
    public static final String FROSTBITE_DURATION = "frostbiteDuration";
    public static final String FROSTBITE_CHANCE = "frostbiteChance";
    public static final String VULNERABLE = "vulnerable";
    public static final String STACKS_USED_PER_HIT = "stacksUsedPerHit";
    public static final String MAX_STACKS = "maxStacks";
    public static final String ATTACK_DAMAGE_PER_STACK = "attackDamagePerStack";
    public static final String ABILITY_POWER_PER_STACK = "abilityPowerPerStack";
    public static final String LUCKY_HIT_PER_STACK = "luckyHitPerStack";
    public static final String MAX_GLACIAL_PRISON = "maxGlacialPrison";
    private static final Map<String, IAbilityComponentFactory> FACTORY_MAP = new HashMap<String, IAbilityComponentFactory>(){
        {
            this.put(AbilityLabelFactory.COOLDOWN, context -> AbilityLabelFactory.label("\n Cooldown: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.COOLDOWN), AbilityLabelFactory.COOLDOWN));
            this.put(AbilityLabelFactory.MANA_COST, context -> AbilityLabelFactory.label("\n Mana Cost: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.MANA_COST), AbilityLabelFactory.MANA_COST));
            this.put(AbilityLabelFactory.MANA_COST_PER_SECOND, context -> AbilityLabelFactory.label("\n Mana / Sec: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.MANA_COST), AbilityLabelFactory.MANA_COST));
            this.put(AbilityLabelFactory.LEVEL, context -> {
                String levelString = AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.LEVEL);
                try {
                    return AbilityLabelFactory.label("\n Min Level: ", levelString, context.vaultLevel() < Integer.parseInt(levelString) ? "levelLo" : "levelHi");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return new TextComponent("ERROR");
                }
            });
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            this.put(AbilityLabelFactory.DISTANCE, context -> AbilityLabelFactory.label("\n Distance: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.DISTANCE), AbilityLabelFactory.DISTANCE));
            this.put(AbilityLabelFactory.DAMAGE, arg_0 -> 1.lambda$new$5((Player)player, arg_0));
            this.put(AbilityLabelFactory.ABILITY_POWER, arg_0 -> 1.lambda$new$6((Player)player, arg_0));
            this.put(AbilityLabelFactory.DURATION, context -> AbilityLabelFactory.label("\n Duration: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.DURATION), AbilityLabelFactory.DURATION));
            this.put(AbilityLabelFactory.DELAY, context -> AbilityLabelFactory.label("\n Delay: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.DELAY), AbilityLabelFactory.DELAY));
            this.put(AbilityLabelFactory.RANGE_HORIZONTAL, context -> AbilityLabelFactory.label("\n XZ Range: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.RANGE_HORIZONTAL), "range"));
            this.put(AbilityLabelFactory.RANGE_VERTICAL, context -> AbilityLabelFactory.label("\n Y Range: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.RANGE_VERTICAL), "range"));
            this.put(AbilityLabelFactory.CHANCE, context -> AbilityLabelFactory.label("\n Chance: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.CHANCE), AbilityLabelFactory.CHANCE));
            this.put(AbilityLabelFactory.HEAL, context -> AbilityLabelFactory.label("\n Heal: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.HEAL), AbilityLabelFactory.HEAL));
            this.put(AbilityLabelFactory.RADIUS, context -> AbilityLabelFactory.label("\n Radius: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.RADIUS), AbilityLabelFactory.RADIUS));
            this.put(AbilityLabelFactory.ABSORB, context -> AbilityLabelFactory.label("\n Absorb: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.ABSORB), AbilityLabelFactory.ABSORB));
            this.put(AbilityLabelFactory.MANA_PER_DAMAGE, context -> AbilityLabelFactory.label("\n Mana / Damage: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.MANA_PER_DAMAGE), AbilityLabelFactory.MANA_PER_DAMAGE));
            this.put(AbilityLabelFactory.KNOCKBACK, context -> AbilityLabelFactory.label("\n Knockback: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.KNOCKBACK), AbilityLabelFactory.KNOCKBACK));
            this.put(AbilityLabelFactory.SLOWNESS, context -> AbilityLabelFactory.label("\n Slowness: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.SLOWNESS), AbilityLabelFactory.SLOWNESS));
            this.put(AbilityLabelFactory.CHILLED, context -> AbilityLabelFactory.label("\n Chilled: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.CHILLED), AbilityLabelFactory.CHILLED));
            this.put(AbilityLabelFactory.CHAINS, context -> AbilityLabelFactory.label("\n Chains: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.CHAINS), AbilityLabelFactory.CHAINS));
            this.put(AbilityLabelFactory.LEECH, context -> AbilityLabelFactory.label("\n Leech: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.LEECH), AbilityLabelFactory.LEECH));
            this.put(AbilityLabelFactory.ETERNALS, context -> AbilityLabelFactory.label("\n Eternals: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.ETERNALS), AbilityLabelFactory.ETERNALS));
            this.put(AbilityLabelFactory.ANCIENT_CHANCE, context -> AbilityLabelFactory.label("\n Ancient Chance: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.CHANCE), AbilityLabelFactory.CHANCE));
            this.put(AbilityLabelFactory.RESISTANCE, context -> AbilityLabelFactory.label("\n Resistance: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.RESISTANCE), AbilityLabelFactory.RESISTANCE));
            this.put(AbilityLabelFactory.SPEED, context -> AbilityLabelFactory.label("\n Speed: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.SPEED), AbilityLabelFactory.SPEED));
            this.put(AbilityLabelFactory.DURABILITY_WEAR_REDUCTION, context -> AbilityLabelFactory.label("\n Unbreaking: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.DURABILITY_WEAR_REDUCTION), AbilityLabelFactory.UNBREAKING));
            this.put(AbilityLabelFactory.RESISTANCE_KNOCKBACK, context -> AbilityLabelFactory.label("\n Knockback Res.: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.RESISTANCE), AbilityLabelFactory.RESISTANCE));
            this.put(AbilityLabelFactory.REDUCED_PROJECTILE_DAMAGE_TAKEN, context -> AbilityLabelFactory.label("\n Projectile Resistance: ", AbilityLabelFactory.binding(context.config(), "projectileDamageTaken"), "projectileDamageTaken"));
            this.put(AbilityLabelFactory.BLOCKS, context -> AbilityLabelFactory.label("\n Blocks: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.BLOCKS), AbilityLabelFactory.BLOCKS));
            this.put(AbilityLabelFactory.UNBREAKING, context -> AbilityLabelFactory.label("\n Unbreaking: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.UNBREAKING), AbilityLabelFactory.UNBREAKING));
            this.put(AbilityLabelFactory.FORTUNE, context -> AbilityLabelFactory.label("\n Fortune: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.FORTUNE), AbilityLabelFactory.FORTUNE));
            this.put(AbilityLabelFactory.MANA_REGEN, context -> AbilityLabelFactory.label("\n Mana Regen: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.MANA_REGEN), AbilityLabelFactory.MANA_COST));
            this.put(AbilityLabelFactory.MAX_TARGETS, context -> AbilityLabelFactory.label("\n Max Targets: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.MAX_TARGETS), AbilityLabelFactory.MAX_TARGETS));
            this.put(AbilityLabelFactory.DAMAGE_REDUCTION, context -> AbilityLabelFactory.label("\n Damage Reduction: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.DAMAGE_REDUCTION), AbilityLabelFactory.DAMAGE_REDUCTION));
            this.put(AbilityLabelFactory.FREEZE_DURATION, context -> AbilityLabelFactory.label("\n Freeze Duration: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.FREEZE_DURATION), AbilityLabelFactory.FREEZE_DURATION));
            this.put(AbilityLabelFactory.DAMAGE_INTERVAL, context -> AbilityLabelFactory.label("\n Damage Interval: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.DAMAGE_INTERVAL), AbilityLabelFactory.DAMAGE_INTERVAL));
            this.put(AbilityLabelFactory.DAMAGE_INCREASE, context -> AbilityLabelFactory.label("\n Damage Dealt: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.DAMAGE_INCREASE), AbilityLabelFactory.DAMAGE));
            this.put(AbilityLabelFactory.PIERCING, context -> AbilityLabelFactory.label("\n Piercing: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.PIERCING), AbilityLabelFactory.PIERCING));
            this.put(AbilityLabelFactory.NUMBER_OF_BOUNCES, context -> AbilityLabelFactory.label("\n Bounces: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.NUMBER_OF_BOUNCES), AbilityLabelFactory.NUMBER_OF_BOUNCES));
            this.put(AbilityLabelFactory.NUMBER_OF_JAVELINS, context -> AbilityLabelFactory.label("\n Javelins: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.NUMBER_OF_JAVELINS), AbilityLabelFactory.NUMBER_OF_JAVELINS));
            this.put(AbilityLabelFactory.THROW_POWER, context -> AbilityLabelFactory.label("\n Throw Power: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.THROW_POWER), AbilityLabelFactory.THROW_POWER));
            this.put(AbilityLabelFactory.AMPLIFIER, context -> AbilityLabelFactory.label("\n Amplifier: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.AMPLIFIER), AbilityLabelFactory.AMPLIFIER));
            this.put(AbilityLabelFactory.MANA_PER_BOLT, context -> AbilityLabelFactory.label("\n Mana Per Bolt: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.MANA_PER_BOLT), AbilityLabelFactory.MANA_COST));
            this.put(AbilityLabelFactory.FORCE, context -> AbilityLabelFactory.label("\n Force: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.FORCE), AbilityLabelFactory.FORCE));
            this.put(AbilityLabelFactory.MANA_PER_HIT, context -> AbilityLabelFactory.label("\n Mana Per Hit: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.MANA_PER_HIT), AbilityLabelFactory.MANA_COST));
            this.put(AbilityLabelFactory.STUN_CHANCE, context -> AbilityLabelFactory.label("\n Stun Chance: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.STUN_CHANCE), AbilityLabelFactory.CHANCE));
            this.put(AbilityLabelFactory.STUN_DURATION, context -> AbilityLabelFactory.label("\n Stun Duration: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.STUN_DURATION), AbilityLabelFactory.DURATION));
            this.put(AbilityLabelFactory.STUN_AMPLIFIER, context -> AbilityLabelFactory.label("\n Stun Amplifier: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.STUN_AMPLIFIER), AbilityLabelFactory.AMPLIFIER));
            this.put(AbilityLabelFactory.QUILL_COUNT, context -> AbilityLabelFactory.label("\n Quill count: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.QUILL_COUNT), AbilityLabelFactory.CHAINS));
            this.put(AbilityLabelFactory.STORM_INTERVAL, context -> AbilityLabelFactory.label("\n Storm Interval: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.STORM_INTERVAL), AbilityLabelFactory.DAMAGE_INTERVAL));
            this.put(AbilityLabelFactory.SLOW_DURATION, context -> AbilityLabelFactory.label("\n Slow Duration: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.SLOW_DURATION), AbilityLabelFactory.FREEZE_DURATION));
            this.put(AbilityLabelFactory.FROSTBITE_DURATION, context -> AbilityLabelFactory.label("\n Frostbite Duration: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.FROSTBITE_DURATION), AbilityLabelFactory.FREEZE_DURATION));
            this.put(AbilityLabelFactory.FROSTBITE_CHANCE, context -> AbilityLabelFactory.label("\n Frostbite Chance: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.FROSTBITE_CHANCE), AbilityLabelFactory.CHANCE));
            this.put(AbilityLabelFactory.VULNERABLE, context -> AbilityLabelFactory.label("\n Vulnerability Levels: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.VULNERABLE), AbilityLabelFactory.AMPLIFIER));
            this.put(AbilityLabelFactory.MAX_STACKS, context -> AbilityLabelFactory.label("\n Max Stacks: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.MAX_STACKS), AbilityLabelFactory.MAX_STACKS));
            this.put(AbilityLabelFactory.STACKS_USED_PER_HIT, context -> AbilityLabelFactory.label("\n Stacks Used Per Hit: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.STACKS_USED_PER_HIT), AbilityLabelFactory.STACKS_USED_PER_HIT));
            this.put(AbilityLabelFactory.ATTACK_DAMAGE_PER_STACK, context -> AbilityLabelFactory.label("\n Attack Damage Per Stack: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.ATTACK_DAMAGE_PER_STACK), AbilityLabelFactory.DAMAGE));
            this.put(AbilityLabelFactory.ABILITY_POWER_PER_STACK, context -> AbilityLabelFactory.label("\n Ability Power Per Stack: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.ABILITY_POWER_PER_STACK), AbilityLabelFactory.ABILITY_POWER));
            this.put(AbilityLabelFactory.LUCKY_HIT_PER_STACK, context -> AbilityLabelFactory.label("\n Lucky Hit Per Stack: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.LUCKY_HIT_PER_STACK), "luckyHit"));
            this.put(AbilityLabelFactory.MAX_GLACIAL_PRISON, context -> AbilityLabelFactory.label("\n Max Glacial Prison: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.MAX_GLACIAL_PRISON), AbilityLabelFactory.MAX_GLACIAL_PRISON));
        }

        private static /* synthetic */ MutableComponent lambda$new$6(Player player, AbilityLabelContext context) {
            return AbilityLabelFactory.labelWithAbilityValue("\n Ability Power: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.ABILITY_POWER), AbilityLabelFactory.ABILITY_POWER, player != null ? AbilityPowerHelper.getAbilityPower(player) : 0.0f);
        }

        private static /* synthetic */ MutableComponent lambda$new$5(Player player, AbilityLabelContext context) {
            return AbilityLabelFactory.labelWithAbilityValue("\n Damage: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.DAMAGE), AbilityLabelFactory.DAMAGE, player != null ? (float)player.m_21133_(Attributes.f_22281_) : 0.0f);
        }
    };

    public static MutableComponent create(String key, AbilityLabelContext<?> context) {
        IAbilityComponentFactory factory = FACTORY_MAP.get(key);
        if (factory == null) {
            return new TextComponent("\n MISSING: " + key);
        }
        return factory.create(context);
    }

    private static <C extends Skill> String binding(C config, String key) {
        return AbilityLabelBindingRegistry.getBindingValue(config, key);
    }

    private static MutableComponent label(String label, String value, String colorKey) {
        return new TextComponent(label).m_130948_(Style.f_131099_.m_131148_(ModConfigs.COLORS.getColor("text"))).m_7220_((Component)AbilityLabelFactory.text(value, colorKey));
    }

    private static MutableComponent labelWithAbilityValue(String label, String value, String colorKey, float abilityValue) {
        float result = Float.parseFloat(value.replace("%", "")) / 100.0f;
        return new TextComponent(label).m_130948_(Style.f_131099_.m_131148_(ModConfigs.COLORS.getColor("text"))).m_7220_((Component)AbilityLabelFactory.text(value, colorKey).m_7220_((Component)AbilityLabelFactory.text(" (" + String.format("%.0f", Float.valueOf(result * abilityValue)) + ")", colorKey)));
    }

    private static MutableComponent text(String text, String colorKey) {
        return AbilityLabelFactory.text(text, ModConfigs.COLORS.getColor(colorKey));
    }

    private static MutableComponent text(String text, TextColor color) {
        return new TextComponent(text).m_130948_(Style.f_131099_.m_131148_(color));
    }

    private AbilityLabelFactory() {
    }

    public static interface IAbilityComponentFactory {
        public MutableComponent create(AbilityLabelContext<?> var1);
    }
}

