/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModSounds;
import iskallia.vault.network.message.BonkParticleMessage;
import iskallia.vault.skill.ability.effect.spi.AbstractBonkAbility;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.util.EntityHelper;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public class BonkLuckyStrikeAbility
extends AbstractBonkAbility {
    private float luckyHitChancePerStack;

    public BonkLuckyStrikeAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, float radius, float luckyHitChancePerStack, int maxStacksUsedPerHit, int maxStacksTotal, int stackDuration) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost, radius, maxStacksUsedPerHit, maxStacksTotal, stackDuration);
        this.luckyHitChancePerStack = luckyHitChancePerStack;
    }

    public BonkLuckyStrikeAbility() {
    }

    public float getLuckyHitChancePerStack() {
        return this.luckyHitChancePerStack;
    }

    @Override
    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            Vec3 pos = context.getSource().getPos().orElse(player.m_20182_());
            List<LivingEntity> targetEntities = this.getTargetEntities(player.f_19853_, (LivingEntity)player, pos);
            int count = 0;
            for (LivingEntity livingEntity : targetEntities) {
                ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new BonkParticleMessage(new Vec3(livingEntity.m_20185_(), livingEntity.m_20186_() + (double)(livingEntity.m_20206_() / 2.0f), livingEntity.m_20189_()), player.m_142049_(), 7206307, 5, 20 + (int)(new Random().nextFloat() * 20.0f)));
                count += EntityHelper.getEntityValue(livingEntity);
            }
            if (count > 0) {
                MobEffectInstance effectInstance;
                MobEffectInstance battleCryEffect = new MobEffectInstance(ModEffects.BATTLE_CRY_LUCKY_STRIKE, this.getStackDuration(), Math.min(count, this.getMaxStacksTotal()) - 1, false, false, true);
                if (player.m_21023_(ModEffects.BATTLE_CRY_LUCKY_STRIKE) && (effectInstance = player.m_21124_(ModEffects.BATTLE_CRY_LUCKY_STRIKE)) != null) {
                    battleCryEffect = new MobEffectInstance(ModEffects.BATTLE_CRY_LUCKY_STRIKE, this.getStackDuration(), Math.min(effectInstance.m_19564_() + 1 + count, this.getMaxStacksTotal()) - 1, false, false, true);
                }
                player.m_21195_(ModEffects.BATTLE_CRY_LUCKY_STRIKE);
                player.m_7292_(battleCryEffect);
            }
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    @Override
    protected void doParticles(SkillContext context) {
    }

    @Override
    protected void doSound(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> {
            Vec3 pos = context.getSource().getPos().orElse(player.m_20182_());
            player.f_19853_.m_6263_((Player)player, pos.f_82479_, pos.f_82480_, pos.f_82481_, ModSounds.BONK_CHARGE, SoundSource.PLAYERS, 1.0f, 0.7f);
            player.m_6330_(ModSounds.BONK_CHARGE, SoundSource.PLAYERS, 1.0f, 0.7f);
        });
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.luckyHitChancePerStack), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.luckyHitChancePerStack = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.luckyHitChancePerStack)).ifPresent(tag -> nbt.m_128365_("luckyHitChancePerStack", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.luckyHitChancePerStack = Adapters.FLOAT.readNbt(nbt.m_128423_("luckyHitChancePerStack")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.luckyHitChancePerStack)).ifPresent(element -> json.add("luckyHitChancePerStack", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.luckyHitChancePerStack = Adapters.FLOAT.readJson(json.get("luckyHitChancePerStack")).orElse(Float.valueOf(0.0f)).floatValue();
    }
}

