/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.entity.entity.VaultFireball;
import iskallia.vault.skill.ability.effect.spi.AbstractFireballAbility;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.base.SkillContext;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;

public class BouncingFireballAbility
extends AbstractFireballAbility {
    int duration;

    public BouncingFireballAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, float percentAttackDamageDealt, float radius, int duration) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost, percentAttackDamageDealt, radius);
        this.duration = duration;
    }

    public BouncingFireballAbility() {
    }

    public int getDuration() {
        return this.duration;
    }

    @Override
    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            VaultFireball fireball = new VaultFireball(player.f_19853_, (LivingEntity)player);
            fireball.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.0f, 0.0f);
            fireball.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
            fireball.setType("bouncing");
            fireball.setDuration(this.duration);
            player.f_19853_.m_7967_((Entity)fireball);
            player.f_19853_.m_6269_((Player)null, (Entity)player, SoundEvents.f_11874_, SoundSource.PLAYERS, 1.0f, 1.0f);
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.duration, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.duration = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.INT.writeNbt(this.duration).ifPresent(tag -> nbt.m_128365_("duration", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.duration = Adapters.INT.readNbt(nbt.m_128423_("duration")).orElse(0);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.INT.writeJson(this.duration).ifPresent(element -> json.add("duration", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.duration = Adapters.INT.readJson(json.get("duration")).orElse(0);
    }
}

