/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModSounds;
import iskallia.vault.mana.Mana;
import iskallia.vault.skill.ability.effect.EmpowerAbility;
import iskallia.vault.skill.ability.effect.spi.AbstractEmpowerAbility;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.tree.AbilityTree;
import iskallia.vault.world.data.PlayerAbilitiesData;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="the_vault", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EmpowerIceArmourAbility
extends AbstractEmpowerAbility {
    private int chilledAmplifier;
    private int chilledDuration;
    private float additionalManaPerHit;

    public EmpowerIceArmourAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCostPerSecond, int durationTicks, float radius, int chilledAmplifier, int chilledDuration, float additionalManaPerHit) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCostPerSecond, durationTicks);
        this.chilledAmplifier = chilledAmplifier;
        this.chilledDuration = chilledDuration;
        this.additionalManaPerHit = additionalManaPerHit;
    }

    public EmpowerIceArmourAbility() {
    }

    public int getChilledAmplifier() {
        return this.chilledAmplifier;
    }

    public int getChilledDuration() {
        return this.chilledDuration;
    }

    public float getAdditionalManaPerHit() {
        return this.additionalManaPerHit;
    }

    @Override
    protected Ability.ActionResult doToggle(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            if (this.isActive()) {
                int amplifier = Mth.m_14045_((int)(this.getChilledAmplifier() * 100), (int)0, (int)100);
                ModEffects.EMPOWER_ICE_ARMOUR.addTo((LivingEntity)player, amplifier);
                return Ability.ActionResult.successCooldownDeferred();
            }
            player.m_21195_((MobEffect)ModEffects.EMPOWER_ICE_ARMOUR);
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    @Override
    protected void doToggleSound(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> {
            if (this.isActive()) {
                player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.EMPOWER_ICE_ARMOUR, SoundSource.MASTER, 0.7f, 1.0f);
                player.m_6330_(ModSounds.EMPOWER_ICE_ARMOUR, SoundSource.MASTER, 0.7f, 1.0f);
            }
        });
    }

    @Override
    public Ability.TickResult doInactiveTick(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            if (player.m_21023_((MobEffect)ModEffects.EMPOWER_ICE_ARMOUR)) {
                player.m_21195_((MobEffect)ModEffects.EMPOWER_ICE_ARMOUR);
            }
            return Ability.TickResult.PASS;
        }).orElse(Ability.TickResult.PASS);
    }

    @Override
    protected void doManaDepleted(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(entity -> entity.m_21195_((MobEffect)ModEffects.EMPOWER_ICE_ARMOUR));
    }

    @Override
    public void onRemove(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(entity -> entity.m_21195_((MobEffect)ModEffects.EMPOWER_ICE_ARMOUR));
    }

    @SubscribeEvent
    public static void onDamage(LivingAttackEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        AbilityTree abilities = PlayerAbilitiesData.get(player.m_183503_()).getAbilities((Player)player);
        abilities.getAll(EmpowerIceArmourAbility.class, Ability::isActive).stream().findFirst().ifPresent(ability -> {
            Entity patt5352$temp = event.getSource().m_7639_();
            if (patt5352$temp instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)patt5352$temp;
                attacker.m_7292_(new MobEffectInstance(ModEffects.CHILLED, ability.getChilledDuration(), ability.getChilledAmplifier(), false, false));
                if (Mana.decrease((Player)player, ability.getAdditionalManaPerHit()) <= 0.0f) {
                    player.m_21195_((MobEffect)ModEffects.SHELL);
                    ability.putOnCooldown(SkillContext.of(player));
                    ability.setActive(false);
                }
            }
        });
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.chilledAmplifier, buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.chilledDuration, buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.additionalManaPerHit), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.chilledAmplifier = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        this.chilledDuration = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        this.additionalManaPerHit = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.INT.writeNbt(this.chilledAmplifier).ifPresent(tag -> nbt.m_128365_("chilledAmplifier", tag));
            Adapters.INT.writeNbt(this.chilledDuration).ifPresent(tag -> nbt.m_128365_("chilledDuration", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.additionalManaPerHit)).ifPresent(tag -> nbt.m_128365_("additionalManaPerHit", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.chilledAmplifier = Adapters.INT.readNbt(nbt.m_128423_("chilledAmplifier")).orElse(0);
        this.chilledDuration = Adapters.INT.readNbt(nbt.m_128423_("chilledDuration")).orElse(0);
        this.additionalManaPerHit = Adapters.FLOAT.readNbt(nbt.m_128423_("additionalManaPerHit")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.INT.writeJson(this.chilledAmplifier).ifPresent(element -> json.add("chilledAmplifier", element));
            Adapters.INT.writeJson(this.chilledDuration).ifPresent(element -> json.add("chilledDuration", element));
            Adapters.FLOAT.writeJson(Float.valueOf(this.additionalManaPerHit)).ifPresent(element -> json.add("additionalManaPerHit", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.chilledAmplifier = Adapters.INT.readJson(json.get("chilledAmplifier")).orElse(0);
        this.chilledDuration = Adapters.INT.readJson(json.get("chilledDuration")).orElse(0);
        this.additionalManaPerHit = Adapters.FLOAT.readJson(json.get("additionalManaPerHit")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public static class EmpowerIceArmourEffect
    extends EmpowerAbility.EmpowerEffect {
        public EmpowerIceArmourEffect(int color, ResourceLocation resourceLocation) {
            super(EmpowerIceArmourEffect.class, color, resourceLocation);
        }
    }
}

