/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModSounds;
import iskallia.vault.skill.ability.effect.EmpowerAbility;
import iskallia.vault.skill.ability.effect.spi.AbstractEmpowerAbility;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.tree.AbilityTree;
import iskallia.vault.util.AABBHelper;
import iskallia.vault.util.calc.AreaOfEffectHelper;
import iskallia.vault.world.data.PlayerAbilitiesData;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="the_vault", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EmpowerSlownessAuraAbility
extends AbstractEmpowerAbility {
    private static final Predicate<LivingEntity> MONSTER_PREDICATE = entity -> entity.m_6095_().m_20674_() == MobCategory.MONSTER;
    private static final int SLOWNESS_TICKS_DURATION = 40;
    private float radius;
    private int slownessAmplifier;

    public EmpowerSlownessAuraAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCostPerSecond, int durationTicks, float radius, int slownessAmplifier) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCostPerSecond, durationTicks);
        this.radius = radius;
        this.slownessAmplifier = slownessAmplifier;
    }

    public EmpowerSlownessAuraAbility() {
    }

    public float getUnmodifiedRadius() {
        return this.radius;
    }

    public float getRadius(Entity attacker) {
        float realRadius = this.getUnmodifiedRadius();
        if (attacker instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)attacker;
            realRadius = AreaOfEffectHelper.adjustAreaOfEffect(livingEntity, realRadius);
        }
        return realRadius;
    }

    public int getSlownessAmplifier() {
        return this.slownessAmplifier;
    }

    @Override
    protected Ability.ActionResult doToggle(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            if (this.isActive()) {
                int amplifier = Mth.m_14045_((int)(this.getSlownessAmplifier() * 100), (int)0, (int)100);
                ModEffects.EMPOWER_SLOWNESS_AURA.addTo((LivingEntity)player, amplifier);
                return Ability.ActionResult.successCooldownDeferred();
            }
            player.m_21195_((MobEffect)ModEffects.EMPOWER_SLOWNESS_AURA);
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    @Override
    protected void doToggleSound(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> {
            if (this.isActive()) {
                player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.EMPOWER_ICE_ARMOUR, SoundSource.MASTER, 0.7f, 1.0f);
                player.m_6330_(ModSounds.EMPOWER_ICE_ARMOUR, SoundSource.MASTER, 0.7f, 1.0f);
            }
        });
    }

    @Override
    public Ability.TickResult doInactiveTick(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            if (player.m_21023_((MobEffect)ModEffects.EMPOWER_SLOWNESS_AURA)) {
                player.m_21195_((MobEffect)ModEffects.EMPOWER_SLOWNESS_AURA);
            }
            return Ability.TickResult.PASS;
        }).orElse(Ability.TickResult.PASS);
    }

    @Override
    protected void doManaDepleted(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(entity -> entity.m_21195_((MobEffect)ModEffects.EMPOWER_SLOWNESS_AURA));
    }

    @Override
    public void onRemove(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(entity -> entity.m_21195_((MobEffect)ModEffects.EMPOWER_SLOWNESS_AURA));
    }

    @SubscribeEvent
    public static void on(LivingEvent.LivingUpdateEvent event) {
        ServerPlayer player;
        LivingEntity livingEntity = event.getEntityLiving();
        if (!(livingEntity instanceof ServerPlayer) || !(player = (ServerPlayer)livingEntity).m_21023_((MobEffect)ModEffects.EMPOWER_SLOWNESS_AURA)) {
            return;
        }
        AbilityTree abilities = PlayerAbilitiesData.get(player.m_183503_()).getAbilities((Player)player);
        for (EmpowerSlownessAuraAbility ability : abilities.getAll(EmpowerSlownessAuraAbility.class, Skill::isUnlocked)) {
            float radius = ability.getRadius((Entity)player);
            List nearbyMobs = player.f_19853_.m_45971_(Mob.class, TargetingConditions.m_148352_().m_26883_((double)radius).m_26888_(MONSTER_PREDICATE), (LivingEntity)player, AABBHelper.create(player.m_20182_(), radius));
            nearbyMobs.forEach(mob -> {
                if (!mob.m_21023_(MobEffects.f_19597_) || mob.m_21124_(MobEffects.f_19597_).m_19564_() < ability.getSlownessAmplifier()) {
                    mob.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, ability.getSlownessAmplifier(), false, true, true));
                }
            });
        }
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.radius), buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.slownessAmplifier, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.radius = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.slownessAmplifier = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.radius)).ifPresent(tag -> nbt.m_128365_("radius", tag));
            Adapters.INT.writeNbt(this.slownessAmplifier).ifPresent(tag -> nbt.m_128365_("slownessAmplifier", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.radius = Adapters.FLOAT.readNbt(nbt.m_128423_("radius")).orElse(Float.valueOf(0.0f)).floatValue();
        this.slownessAmplifier = Adapters.INT.readNbt(nbt.m_128423_("slownessAmplifier")).orElse(0);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.radius)).ifPresent(element -> json.add("radius", element));
            Adapters.INT.writeJson(this.slownessAmplifier).ifPresent(element -> json.add("slownessAmplifier", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.radius = Adapters.FLOAT.readJson(json.get("radius")).orElse(Float.valueOf(0.0f)).floatValue();
        this.slownessAmplifier = Adapters.INT.readJson(json.get("slownessAmplifier")).orElse(0);
    }

    public static class EmpowerSlownessAuraEffect
    extends EmpowerAbility.EmpowerEffect {
        public EmpowerSlownessAuraEffect(int color, ResourceLocation resourceLocation) {
            super(EmpowerSlownessAuraEffect.class, color, resourceLocation);
        }
    }
}

