/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.gear.attribute.ability.special.ExecuteHealthModification;
import iskallia.vault.gear.attribute.ability.special.base.ConfiguredModification;
import iskallia.vault.gear.attribute.ability.special.base.SpecialAbilityModification;
import iskallia.vault.gear.attribute.ability.special.base.template.FloatValueConfig;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModSounds;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.ability.effect.spi.core.InstantAbility;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.tree.AbilityTree;
import iskallia.vault.world.data.PlayerAbilitiesData;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="the_vault", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ExecuteAbility
extends InstantAbility {
    private float damageHealthPercentage;
    private int effectDurationTicks;

    public ExecuteAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float damageHealthPercentage, int effectDurationTicks) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks);
        this.damageHealthPercentage = damageHealthPercentage;
        this.effectDurationTicks = effectDurationTicks;
    }

    public ExecuteAbility() {
    }

    public float getDamageHealthPercentage() {
        return this.damageHealthPercentage;
    }

    public int getEffectDurationTicks() {
        return this.effectDurationTicks;
    }

    @Override
    public String getAbilityGroupName() {
        return "Execute";
    }

    @Override
    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            if (player.m_21023_(ModEffects.EXECUTE)) {
                return Ability.ActionResult.fail();
            }
            MobEffectInstance newEffect = new MobEffectInstance(ModEffects.EXECUTE, this.effectDurationTicks, 0, false, false, true);
            player.m_7292_(newEffect);
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    @Override
    protected void doParticles(SkillContext context) {
    }

    @Override
    protected void doSound(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> {
            player.f_19853_.m_6263_((Player)player, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.EXECUTION_SFX, SoundSource.PLAYERS, 0.4f, 1.0f);
            player.m_6330_(ModSounds.EXECUTION_SFX, SoundSource.PLAYERS, 0.4f, 1.0f);
        });
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void on(LivingHurtEvent event) {
        ServerPlayer serverPlayer;
        Entity entity;
        if (event.getEntity().m_20193_().m_5776_() || !((entity = event.getSource().m_7639_()) instanceof ServerPlayer) || !((entity = (serverPlayer = (ServerPlayer)entity).m_20193_()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)entity;
        MobEffectInstance effectInstance = serverPlayer.m_21124_(ModEffects.EXECUTE);
        if (effectInstance == null) {
            return;
        }
        PlayerAbilitiesData data = PlayerAbilitiesData.get(serverLevel);
        AbilityTree abilities = data.getAbilities((Player)serverPlayer);
        for (ExecuteAbility ability : abilities.getAll(ExecuteAbility.class, Skill::isUnlocked)) {
            float dmgPercentage = ability.damageHealthPercentage;
            for (ConfiguredModification mod : SpecialAbilityModification.getModifications((LivingEntity)serverPlayer, ExecuteHealthModification.class)) {
                dmgPercentage = mod.modification().adjustHealthPercent((FloatValueConfig)mod.config(), dmgPercentage);
            }
            float maxHealth = event.getEntityLiving().m_21233_();
            float damageDealt = maxHealth * dmgPercentage;
            event.setAmount(event.getAmount() + damageDealt);
            serverPlayer.m_21195_(ModEffects.EXECUTE);
        }
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.damageHealthPercentage), buffer);
        Adapters.INT_SEGMENTED_7.writeBits(this.effectDurationTicks, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.damageHealthPercentage = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.effectDurationTicks = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.damageHealthPercentage)).ifPresent(tag -> nbt.m_128365_("damageHealthPercentage", tag));
            Adapters.INT.writeNbt(this.effectDurationTicks).ifPresent(tag -> nbt.m_128365_("effectDurationTicks", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.damageHealthPercentage = Adapters.FLOAT.readNbt(nbt.m_128423_("damageHealthPercentage")).orElse(Float.valueOf(0.0f)).floatValue();
        this.effectDurationTicks = Adapters.INT.readNbt(nbt.m_128423_("effectDurationTicks")).orElse(0);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.damageHealthPercentage)).ifPresent(element -> json.add("damageHealthPercentage", element));
            Adapters.INT.writeJson(this.effectDurationTicks).ifPresent(element -> json.add("effectDurationTicks", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.damageHealthPercentage = Adapters.FLOAT.readJson(json.get("damageHealthPercentage")).orElse(Float.valueOf(0.0f)).floatValue();
        this.effectDurationTicks = Adapters.INT.readJson(json.get("effectDurationTicks")).orElse(0);
    }

    public static class ExecuteEffect
    extends MobEffect {
        public ExecuteEffect(MobEffectCategory type, int color, ResourceLocation id) {
            super(type, color);
            this.setRegistryName(id);
        }
    }
}

