/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.skill.ability.effect.FarmerAbility;
import iskallia.vault.util.AABBHelper;
import iskallia.vault.util.calc.AreaOfEffectHelper;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;

public class FarmerAnimalAbility
extends FarmerAbility {
    private static final int PARTICLE_COUNT = 20;
    private static final Predicate<AgeableMob> AGEABLE_MOB_PREDICATE = entity -> entity.m_6084_() && !entity.m_5833_() && entity.m_6162_();
    private float adultChance;

    public FarmerAnimalAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCostPerSecond, int tickDelay, int horizontalRange, int verticalRange, float adultChance) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCostPerSecond, tickDelay, horizontalRange, verticalRange);
        this.adultChance = adultChance;
    }

    public FarmerAnimalAbility() {
    }

    public float getAdultChance() {
        return this.adultChance;
    }

    @Override
    protected void doGrow(ServerPlayer player, ServerLevel world) {
        super.doGrow(player, world);
        int horizontalRange = this.getHorizontalRange();
        int verticalRange = this.getVerticalRange();
        horizontalRange = Math.round(AreaOfEffectHelper.adjustAreaOfEffect((LivingEntity)player, horizontalRange));
        verticalRange = Math.round(AreaOfEffectHelper.adjustAreaOfEffect((LivingEntity)player, verticalRange));
        AABB searchBox = AABBHelper.create(player.m_20182_(), horizontalRange, verticalRange, horizontalRange);
        List entities = world.m_6443_(AgeableMob.class, searchBox, AGEABLE_MOB_PREDICATE);
        for (AgeableMob entity : entities) {
            if (world.m_5822_().nextFloat() < 0.4f) {
                world.m_8767_((ParticleOptions)ParticleTypes.f_123748_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 20, 0.5, 0.5, 0.5, 0.0);
            }
            if (!(world.m_5822_().nextFloat() < this.getAdultChance())) continue;
            entity.m_6863_(false);
        }
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.adultChance), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.adultChance = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.adultChance)).ifPresent(tag -> nbt.m_128365_("adultChance", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.adultChance = Adapters.FLOAT.readNbt(nbt.m_128423_("adultChance")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.adultChance)).ifPresent(element -> json.add("adultChance", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.adultChance = Adapters.FLOAT.readJson(json.get("adultChance")).orElse(Float.valueOf(0.0f)).floatValue();
    }
}

