/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import com.mojang.math.Vector3f;
import iskallia.vault.client.particles.SphericalParticleOptions;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.init.ModParticles;
import iskallia.vault.init.ModSounds;
import iskallia.vault.skill.ability.effect.spi.AbstractHealAbility;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.util.AABBHelper;
import iskallia.vault.util.calc.AreaOfEffectHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class HealGroupAbility
extends AbstractHealAbility {
    private float radius;

    public HealGroupAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, float radius) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost);
        this.radius = radius;
    }

    public HealGroupAbility() {
    }

    public float getUnmodifiedRadius() {
        return this.radius;
    }

    public float getRadius(Entity attacker) {
        float realRadius = this.getUnmodifiedRadius();
        if (attacker instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)attacker;
            realRadius = AreaOfEffectHelper.adjustAreaOfEffect(livingEntity, realRadius);
        }
        return realRadius;
    }

    @Override
    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            List nearbyEntities = player.f_19853_.m_45971_(LivingEntity.class, TargetingConditions.m_148353_().m_26888_(entity -> entity instanceof Player).m_26883_((double)this.radius), (LivingEntity)player, AABBHelper.create(player.m_20182_(), this.radius));
            for (LivingEntity nearbyEntity : nearbyEntities) {
                nearbyEntity.m_5634_(this.flatLifeHealed);
            }
            player.m_5634_(this.flatLifeHealed);
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    @Override
    protected void doParticles(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> {
            Level patt2847$temp = player.f_19853_;
            if (!(patt2847$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)patt2847$temp;
            Vec3 position = player.m_20182_();
            float radius = this.getRadius((Entity)player);
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.HEAL.get()), position.f_82479_, position.f_82480_, position.f_82481_, 25, (double)radius * 0.5, 0.5, (double)radius * 0.5, 0.0);
            serverLevel.m_8767_((ParticleOptions)new SphericalParticleOptions((ParticleType<SphericalParticleOptions>)((ParticleType)ModParticles.HEAL_GROUP_EFFECT_RANGE.get()), radius, new Vector3f(1.0f, 1.0f, 1.0f)), position.f_82479_, position.f_82480_, position.f_82481_, 200, 0.0, 0.0, 0.0, 0.0);
            serverLevel.m_8767_((ParticleOptions)new SphericalParticleOptions((ParticleType<SphericalParticleOptions>)((ParticleType)ModParticles.HEAL_GROUP_EFFECT_RING.get()), radius, new Vector3f(1.0f, 1.0f, 1.0f)), position.f_82479_, position.f_82480_, position.f_82481_, 200, 0.0, 1.0, 0.0, 0.0);
        });
    }

    @Override
    protected void doSound(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> {
            player.f_19853_.m_6263_((Player)player, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.HEAL, SoundSource.PLAYERS, 0.5f, 1.0f);
            player.m_6330_(ModSounds.HEAL, SoundSource.PLAYERS, 0.5f, 1.0f);
        });
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.radius), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.radius = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.radius)).ifPresent(tag -> nbt.m_128365_("radius", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.radius = Adapters.FLOAT.readNbt(nbt.m_128423_("radius")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.radius)).ifPresent(element -> json.add("radius", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.radius = Adapters.FLOAT.readJson(json.get("radius")).orElse(Float.valueOf(0.0f)).floatValue();
    }
}

