/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.entity.entity.VaultThrownJavelin;
import iskallia.vault.mana.FullManaPlayer;
import iskallia.vault.skill.ability.effect.spi.AbstractJavelinAbility;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.talent.type.JavelinFrugalTalent;
import iskallia.vault.skill.tree.TalentTree;
import iskallia.vault.world.data.PlayerTalentsData;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;

public class JavelinAbility
extends AbstractJavelinAbility {
    private float knockback;

    public JavelinAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, float percentAttackDamageDealt, float throwPower, float knockback) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost, percentAttackDamageDealt, throwPower);
        this.knockback = knockback;
    }

    public JavelinAbility() {
    }

    public float getKnockback() {
        return this.knockback;
    }

    @Override
    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            VaultThrownJavelin thrownJavelin = new VaultThrownJavelin(player.f_19853_, (LivingEntity)player);
            thrownJavelin.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, this.getThrowPower((ServerPlayer)player), 1.0f);
            thrownJavelin.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
            thrownJavelin.setType("base");
            TalentTree talents = PlayerTalentsData.get(player.m_183503_()).getTalents((Player)player);
            for (JavelinFrugalTalent talent : talents.getAll(JavelinFrugalTalent.class, Skill::isUnlocked)) {
                if (!(talent.getFrugalChance() >= player.m_21187_().nextFloat())) continue;
                context.getSource().setMana(FullManaPlayer.INSTANCE);
                thrownJavelin.setIsGhost();
            }
            player.f_19853_.m_7967_((Entity)thrownJavelin);
            player.f_19853_.m_6269_((Player)null, (Entity)thrownJavelin, SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, 1.0f);
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.knockback), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.knockback = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.knockback)).ifPresent(tag -> nbt.m_128365_("knockback", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.knockback = Adapters.FLOAT.readNbt(nbt.m_128423_("knockback")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.knockback)).ifPresent(element -> json.add("knockback", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.knockback = Adapters.FLOAT.readJson(json.get("knockback")).orElse(Float.valueOf(0.0f)).floatValue();
    }
}

