/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.gear.attribute.ability.special.ManaShieldAbsorptionModification;
import iskallia.vault.gear.attribute.ability.special.base.ConfiguredModification;
import iskallia.vault.gear.attribute.ability.special.base.SpecialAbilityModification;
import iskallia.vault.gear.attribute.ability.special.base.template.FloatValueConfig;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModSounds;
import iskallia.vault.mana.Mana;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.ability.effect.spi.core.ToggleAbilityEffect;
import iskallia.vault.skill.ability.effect.spi.core.ToggleManaAbility;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.tree.AbilityTree;
import iskallia.vault.world.data.PlayerAbilitiesData;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="the_vault", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ManaShieldAbility
extends ToggleManaAbility {
    private float percentageDamageAbsorbed;
    private float manaPerDamageScalar;

    public ManaShieldAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCostPerSecond, float percentageDamageAbsorbed, float manaPerDamageScalar) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCostPerSecond);
        this.percentageDamageAbsorbed = percentageDamageAbsorbed;
        this.manaPerDamageScalar = manaPerDamageScalar;
    }

    public ManaShieldAbility() {
    }

    public float getPercentageDamageAbsorbed() {
        return this.percentageDamageAbsorbed;
    }

    public float getManaPerDamageScalar() {
        return this.manaPerDamageScalar;
    }

    @Override
    public String getAbilityGroupName() {
        return "Mana Shield";
    }

    protected ToggleAbilityEffect getEffect() {
        return ModEffects.MANA_SHIELD;
    }

    @Override
    protected Ability.ActionResult doToggle(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            if (this.isActive()) {
                this.getEffect().addTo((LivingEntity)player, 0);
                return Ability.ActionResult.successCooldownDeferred();
            }
            player.m_21195_((MobEffect)this.getEffect());
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    @Override
    protected void doToggleSound(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> {
            if (this.isActive()) {
                player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.MANA_SHIELD, SoundSource.MASTER, 0.2f, 1.0f);
                player.m_6330_(ModSounds.MANA_SHIELD, SoundSource.MASTER, 0.2f, 1.0f);
            }
        });
    }

    @Override
    public Ability.TickResult doInactiveTick(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            if (player.m_21023_((MobEffect)this.getEffect())) {
                player.m_21195_((MobEffect)this.getEffect());
            }
            return Ability.TickResult.PASS;
        }).orElse(Ability.TickResult.PASS);
    }

    @Override
    protected void doManaDepleted(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(entity -> entity.m_21195_((MobEffect)this.getEffect()));
    }

    @Override
    public void onRemove(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(entity -> entity.m_21195_((MobEffect)this.getEffect()));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void on(LivingDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        AbilityTree abilities = PlayerAbilitiesData.get(player.m_183503_()).getAbilities((Player)player);
        for (ManaShieldAbility ability : abilities.getAll(ManaShieldAbility.class, Skill::isUnlocked)) {
            if (!player.m_21023_((MobEffect)ability.getEffect())) continue;
            float percentageDamageAbsorbed = Mth.m_14036_((float)ability.getPercentageDamageAbsorbed(), (float)0.0f, (float)1.0f);
            float manaCostPerDamage = ability.getManaPerDamageScalar();
            for (ConfiguredModification mod : SpecialAbilityModification.getModifications((LivingEntity)player, ManaShieldAbsorptionModification.class)) {
                manaCostPerDamage = mod.modification().adjustAbsorptionDamageCost((FloatValueConfig)mod.config(), manaCostPerDamage);
            }
            manaCostPerDamage = Math.max(manaCostPerDamage, 1.0E-5f);
            float manaUsed = Math.min(event.getAmount() * percentageDamageAbsorbed * manaCostPerDamage, Mana.get((Player)player));
            float damageAbsorbed = manaUsed / manaCostPerDamage;
            if (Mth.m_14033_((float)damageAbsorbed, (float)0.0f)) {
                return;
            }
            if (Mth.m_14033_((float)damageAbsorbed, (float)event.getAmount())) {
                event.setCanceled(true);
            } else {
                event.setAmount(event.getAmount() - damageAbsorbed);
            }
            float mana = Mana.decrease((Player)player, manaUsed);
            ability.onDamageAbsorbed(player, damageAbsorbed);
            float pitch = 1.25f + -0.5f * (mana / Mana.getMax((Player)player));
            player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.MANA_SHIELD_HIT, SoundSource.PLAYERS, 0.03f, pitch);
        }
    }

    protected void onDamageAbsorbed(ServerPlayer player, float amount) {
    }

    protected void onEffectRemoved(ServerPlayer player) {
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.percentageDamageAbsorbed), buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.manaPerDamageScalar), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.percentageDamageAbsorbed = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.manaPerDamageScalar = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.percentageDamageAbsorbed)).ifPresent(tag -> nbt.m_128365_("percentageDamageAbsorbed", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.manaPerDamageScalar)).ifPresent(tag -> nbt.m_128365_("manaPerDamageScalar", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.percentageDamageAbsorbed = Adapters.FLOAT.readNbt(nbt.m_128423_("percentageDamageAbsorbed")).orElse(Float.valueOf(0.0f)).floatValue();
        this.manaPerDamageScalar = Adapters.FLOAT.readNbt(nbt.m_128423_("manaPerDamageScalar")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.percentageDamageAbsorbed)).ifPresent(element -> json.add("percentageDamageAbsorbed", element));
            Adapters.FLOAT.writeJson(Float.valueOf(this.manaPerDamageScalar)).ifPresent(element -> json.add("manaPerDamageScalar", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.percentageDamageAbsorbed = Adapters.FLOAT.readJson(json.get("percentageDamageAbsorbed")).orElse(Float.valueOf(0.0f)).floatValue();
        this.manaPerDamageScalar = Adapters.FLOAT.readJson(json.get("manaPerDamageScalar")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public static class ManaShieldEffect
    extends ToggleAbilityEffect {
        public ManaShieldEffect(int color, ResourceLocation resourceLocation) {
            super(ManaShieldAbility.class, color, resourceLocation);
        }

        @Override
        protected void removeAttributeModifiers(ServerPlayer player, AttributeMap attributeMap, int amplifier) {
            super.removeAttributeModifiers(player, attributeMap, amplifier);
            if (player.m_21023_((MobEffect)this)) {
                return;
            }
            AbilityTree abilities = PlayerAbilitiesData.get(player.m_183503_()).getAbilities((Player)player);
            for (ManaShieldAbility ability : abilities.getAll(ManaShieldAbility.class, Skill::isUnlocked)) {
                ability.onEffectRemoved(player);
            }
        }
    }
}

