/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import com.mojang.math.Vector3f;
import iskallia.vault.client.particles.SphericalParticleOptions;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.entity.entity.EternalEntity;
import iskallia.vault.event.ActiveFlags;
import iskallia.vault.gear.attribute.ability.special.ManaShieldImplodeRadiusModification;
import iskallia.vault.gear.attribute.ability.special.base.ConfiguredModification;
import iskallia.vault.gear.attribute.ability.special.base.SpecialAbilityModification;
import iskallia.vault.gear.attribute.ability.special.base.template.FloatValueConfig;
import iskallia.vault.init.ModParticles;
import iskallia.vault.init.ModSounds;
import iskallia.vault.mana.ManaPlayer;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.ability.effect.spi.core.InstantManaAbility;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.util.AABBHelper;
import iskallia.vault.util.calc.AreaOfEffectHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="the_vault", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ManaShieldImplodeAbility
extends InstantManaAbility {
    private float radius;
    private float percentManaDealt;

    public ManaShieldImplodeAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, float radius, float percentManaDealt) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost);
        this.radius = radius;
        this.percentManaDealt = percentManaDealt;
    }

    public ManaShieldImplodeAbility() {
    }

    public float getPercentManaDealt() {
        return this.percentManaDealt;
    }

    @Override
    public String getAbilityGroupName() {
        return "Mana Shield";
    }

    @Override
    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            Vec3 pos = context.getSource().getPos().orElse(player.m_20182_());
            List<LivingEntity> targetEntities = this.getTargetEntities(player.f_19853_, (LivingEntity)player, pos);
            ManaPlayer manaPlayer = context.getSource().getMana().orElse(null);
            DamageSource damageSource = DamageSource.m_19344_((Player)player);
            if (manaPlayer != null) {
                float mana = manaPlayer.getMana();
                for (LivingEntity entity : targetEntities) {
                    float damageModifier = this.getDamageModifier(this.getRadius((Entity)player), player.m_20270_((Entity)entity));
                    ActiveFlags.IS_AOE_ATTACKING.runIfNotSet(() -> entity.m_6469_(damageSource, mana * this.getPercentManaDealt() * damageModifier));
                }
                player.m_183503_().m_8767_((ParticleOptions)new SphericalParticleOptions((ParticleType<SphericalParticleOptions>)((ParticleType)ModParticles.IMPLODE.get()), this.getRadius((Entity)player), new Vector3f(0.0f, 1.0f, 1.0f)), player.m_20185_(), player.m_20186_(), player.m_20189_(), 400, 0.0, 0.0, 0.0, 0.0);
                player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.MANA_SHIELD, SoundSource.PLAYERS, 0.2f, 0.2f);
                player.m_6330_(ModSounds.MANA_SHIELD, SoundSource.PLAYERS, 0.2f, 0.2f);
                if (!player.m_7500_()) {
                    manaPlayer.decreaseMana(mana);
                }
            }
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    protected float getDamageModifier(float radius, float dist) {
        if (dist >= 0.0f && dist < radius / 5.0f * 1.0f) {
            return 1.0f;
        }
        if (dist >= radius / 5.0f * 1.0f && dist < radius / 5.0f * 2.0f) {
            return 0.8f;
        }
        if (dist >= radius / 5.0f * 2.0f && dist < radius / 5.0f * 3.0f) {
            return 0.6f;
        }
        if (dist >= radius / 5.0f * 3.0f && dist < radius / 5.0f * 4.0f) {
            return 0.4f;
        }
        if (dist >= radius / 5.0f * 4.0f) {
            return 0.2f;
        }
        return 0.2f;
    }

    public float getUnmodifiedRadius() {
        return this.radius;
    }

    public float getRadius(Entity attacker) {
        float realRadius = this.getUnmodifiedRadius();
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            for (ConfiguredModification mod : SpecialAbilityModification.getModifications((LivingEntity)player, ManaShieldImplodeRadiusModification.class)) {
                realRadius = mod.modification().adjustRadius((FloatValueConfig)mod.config(), realRadius);
            }
        }
        if (attacker instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)attacker;
            realRadius = AreaOfEffectHelper.adjustAreaOfEffect(livingEntity, realRadius);
        }
        return realRadius;
    }

    @NotNull
    protected List<LivingEntity> getTargetEntities(Level world, LivingEntity attacker, Vec3 pos) {
        float radius = this.getRadius((Entity)attacker);
        return world.m_45971_(LivingEntity.class, TargetingConditions.m_148352_().m_26883_((double)radius).m_26888_(entity -> !(entity instanceof Player) && !(entity instanceof EternalEntity)), attacker, AABBHelper.create(pos, radius));
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.radius), buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.percentManaDealt), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.radius = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.percentManaDealt = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.radius)).ifPresent(tag -> nbt.m_128365_("radius", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.percentManaDealt)).ifPresent(tag -> nbt.m_128365_("percentManaDealt", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.radius = Adapters.FLOAT.readNbt(nbt.m_128423_("radius")).orElse(Float.valueOf(0.0f)).floatValue();
        this.percentManaDealt = Adapters.FLOAT.readNbt(nbt.m_128423_("percentManaDealt")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.radius)).ifPresent(element -> json.add("radius", element));
            Adapters.FLOAT.writeJson(Float.valueOf(this.percentManaDealt)).ifPresent(element -> json.add("percentManaDealt", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.radius = Adapters.FLOAT.readJson(json.get("radius")).orElse(Float.valueOf(0.0f)).floatValue();
        this.percentManaDealt = Adapters.FLOAT.readJson(json.get("percentManaDealt")).orElse(Float.valueOf(0.0f)).floatValue();
    }
}

