/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import com.mojang.math.Vector3f;
import iskallia.vault.client.particles.SphericalParticleOptions;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.event.ActiveFlags;
import iskallia.vault.event.ActiveFlagsCheck;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModParticles;
import iskallia.vault.skill.ability.effect.ManaShieldAbility;
import iskallia.vault.skill.ability.effect.spi.core.ToggleAbilityEffect;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.tree.AbilityTree;
import iskallia.vault.util.AABBHelper;
import iskallia.vault.util.EntityHelper;
import iskallia.vault.util.calc.AreaOfEffectHelper;
import iskallia.vault.util.damage.AttackScaleHelper;
import iskallia.vault.util.damage.CritHelper;
import iskallia.vault.util.damage.ThornsReflectDamageSource;
import iskallia.vault.world.data.PlayerAbilitiesData;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="the_vault", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ManaShieldRetributionAbility
extends ManaShieldAbility {
    private float damageRadius;
    private float percentageDamageDealt;
    private static final Map<UUID, FloatContainer> DAMAGE_POOL_MAP = new HashMap<UUID, FloatContainer>();
    private static final Predicate<Entity> ENTITY_SELECTION_FILTER = entity -> {
        LivingEntity livingEntity;
        return !(entity instanceof Player) && entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_6084_();
    };

    public ManaShieldRetributionAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCostPerSecond, float percentageDamageAbsorbed, float manaPerDamageScalar, float damageRadius, float percentageDamageDealt) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCostPerSecond, percentageDamageAbsorbed, manaPerDamageScalar);
        this.damageRadius = damageRadius;
        this.percentageDamageDealt = percentageDamageDealt;
    }

    public ManaShieldRetributionAbility() {
    }

    public float getUnmodifiedDamageRadius() {
        return this.damageRadius;
    }

    public float getRadius(Entity attacker) {
        float realRadius = this.getUnmodifiedDamageRadius();
        if (attacker instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)attacker;
            realRadius = AreaOfEffectHelper.adjustAreaOfEffect(livingEntity, realRadius);
        }
        return realRadius;
    }

    public float getPercentageDamageDealt() {
        return this.percentageDamageDealt;
    }

    @Override
    protected ToggleAbilityEffect getEffect() {
        return ModEffects.MANA_SHIELD_RETRIBUTION;
    }

    @Override
    protected void onDamageAbsorbed(ServerPlayer player, float amount) {
        ManaShieldRetributionAbility.DAMAGE_POOL_MAP.computeIfAbsent((UUID)player.m_142081_(), (Function<UUID, FloatContainer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$onDamageAbsorbed$0(java.util.UUID ), (Ljava/util/UUID;)Liskallia/vault/skill/ability/effect/ManaShieldRetributionAbility$FloatContainer;)()).value += amount;
    }

    @Override
    protected void onEffectRemoved(ServerPlayer player) {
        ManaShieldRetributionAbility.resetDamageAbsorbed(player);
    }

    private static float getDamageAbsorbed(ServerPlayer player) {
        return ManaShieldRetributionAbility.DAMAGE_POOL_MAP.getOrDefault((Object)player.m_142081_(), (FloatContainer)FloatContainer.DEFAULT).value;
    }

    private static void resetDamageAbsorbed(ServerPlayer player) {
        DAMAGE_POOL_MAP.remove(player.m_142081_());
    }

    @SubscribeEvent
    public static void on(LivingHurtEvent event) {
        ServerPlayer serverPlayer;
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof ServerPlayer) || !(serverPlayer = (ServerPlayer)entity).m_21023_((MobEffect)ModEffects.MANA_SHIELD_RETRIBUTION) || event.getSource() instanceof ThornsReflectDamageSource) {
            return;
        }
        float damageAbsorbed = ManaShieldRetributionAbility.getDamageAbsorbed(serverPlayer);
        if (Mth.m_14033_((float)damageAbsorbed, (float)0.0f)) {
            return;
        }
        if (ActiveFlagsCheck.isAnyFlagActiveLuckyHit()) {
            return;
        }
        if (event.getSource() instanceof ThornsReflectDamageSource) {
            return;
        }
        Entity source = event.getSource().m_7639_();
        if (!(source instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer attacker = (ServerPlayer)source;
        if (CritHelper.getCrit((Player)attacker)) {
            return;
        }
        if (AttackScaleHelper.getLastAttackScale((Player)attacker) < 1.0f) {
            return;
        }
        AbilityTree abilities = PlayerAbilitiesData.get(serverPlayer.m_183503_()).getAbilities((Player)serverPlayer);
        for (ManaShieldRetributionAbility ability : abilities.getAll(ManaShieldRetributionAbility.class, Skill::isUnlocked)) {
            Vec3 origin = event.getEntity().m_20182_();
            float damageRadius = ability.getRadius((Entity)serverPlayer);
            AABB bounds = AABBHelper.create(origin, damageRadius);
            ArrayList<LivingEntity> result = new ArrayList<LivingEntity>();
            EntityHelper.getEntitiesInRange((LevelAccessor)serverPlayer.f_19853_, bounds, origin, damageRadius, ENTITY_SELECTION_FILTER, result);
            AttributeInstance attributeInstance = serverPlayer.m_21051_(Attributes.f_22281_);
            if (attributeInstance == null) {
                return;
            }
            ActiveFlags.IS_AOE_ATTACKING.runIfNotSet(() -> {
                event.setCanceled(true);
                float damage = (float)(attributeInstance.m_22135_() + (double)(damageAbsorbed * ability.getPercentageDamageDealt()));
                for (LivingEntity entity : result) {
                    entity.m_6469_(DamageSource.m_19344_((Player)serverPlayer), damage);
                }
            });
            serverPlayer.m_183503_().m_8767_((ParticleOptions)new SphericalParticleOptions((ParticleType<SphericalParticleOptions>)((ParticleType)ModParticles.MANA_SHIELD_RETRIBUTION_EFFECT_RANGE.get()), damageRadius, new Vector3f(0.0f, 1.0f, 1.0f)), origin.f_82479_, origin.f_82480_, origin.f_82481_, 200, 0.0, 0.0, 0.0, 0.0);
        }
        ManaShieldRetributionAbility.resetDamageAbsorbed(serverPlayer);
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.damageRadius), buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.percentageDamageDealt), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.damageRadius = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.percentageDamageDealt = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.damageRadius)).ifPresent(tag -> nbt.m_128365_("damageRadius", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.percentageDamageDealt)).ifPresent(tag -> nbt.m_128365_("percentageDamageDealt", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.damageRadius = Adapters.FLOAT.readNbt(nbt.m_128423_("damageRadius")).orElse(Float.valueOf(0.0f)).floatValue();
        this.percentageDamageDealt = Adapters.FLOAT.readNbt(nbt.m_128423_("percentageDamageDealt")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.damageRadius)).ifPresent(element -> json.add("damageRadius", element));
            Adapters.FLOAT.writeJson(Float.valueOf(this.percentageDamageDealt)).ifPresent(element -> json.add("percentageDamageDealt", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.damageRadius = Adapters.FLOAT.readJson(json.get("damageRadius")).orElse(Float.valueOf(0.0f)).floatValue();
        this.percentageDamageDealt = Adapters.FLOAT.readJson(json.get("percentageDamageDealt")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    private static /* synthetic */ FloatContainer lambda$onDamageAbsorbed$0(UUID uuid) {
        return new FloatContainer();
    }

    private static class FloatContainer {
        private static final FloatContainer DEFAULT = new FloatContainer();
        private float value;

        private FloatContainer() {
        }
    }
}

