/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.gear.attribute.ability.special.MegaJumpVelocityModification;
import iskallia.vault.gear.attribute.ability.special.base.ConfiguredModification;
import iskallia.vault.gear.attribute.ability.special.base.SpecialAbilityModification;
import iskallia.vault.gear.attribute.ability.special.base.template.IntValueConfig;
import iskallia.vault.init.ModSounds;
import iskallia.vault.skill.ability.effect.spi.AbstractMegaJumpAbility;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.util.calc.AreaOfEffectHelper;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class MegaJumpAbility
extends AbstractMegaJumpAbility {
    private int height;

    public MegaJumpAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, int height) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost);
        this.height = height;
    }

    public MegaJumpAbility() {
    }

    public int getUnmodifiedHeight() {
        return this.height;
    }

    public int getHeight(Player player) {
        int realHeight = this.getUnmodifiedHeight();
        for (ConfiguredModification mod : SpecialAbilityModification.getModifications((LivingEntity)player, MegaJumpVelocityModification.class)) {
            realHeight = mod.modification().adjustHeightConfig((IntValueConfig)mod.config(), realHeight);
        }
        return Math.round(AreaOfEffectHelper.adjustAreaOfEffect((LivingEntity)player, realHeight));
    }

    @Override
    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            int height = this.getHeight((Player)player);
            if (height == 0) {
                return Ability.ActionResult.successCooldownImmediate();
            }
            double magnitude = (double)height * 0.15;
            double addY = -Math.min(0.0, player.m_20184_().m_7098_());
            player.m_5997_(0.0, addY + magnitude, 0.0);
            player.m_36320_();
            player.f_19864_ = true;
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    @Override
    protected void doParticles(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> ((ServerLevel)player.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123759_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 50, 1.0, 0.5, 1.0, 0.0));
    }

    @Override
    protected void doSound(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> {
            player.m_6330_(ModSounds.MEGA_JUMP_SFX, SoundSource.PLAYERS, 0.3f, 1.0f);
            player.f_19853_.m_6263_((Player)player, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.MEGA_JUMP_SFX, SoundSource.PLAYERS, 0.3f, 1.0f);
        });
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.height, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.height = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.INT.writeNbt(this.height).ifPresent(tag -> nbt.m_128365_("height", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.height = Adapters.INT.readNbt(nbt.m_128423_("height")).orElse(0);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.INT.writeJson(this.height).ifPresent(element -> json.add("height", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.height = Adapters.INT.readJson(json.get("height")).orElse(0);
    }
}

