/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModParticles;
import iskallia.vault.skill.ability.effect.spi.AbstractNovaAbility;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.util.damage.DamageOverTimeHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.phys.Vec3;

public class NovaDotAbility
extends AbstractNovaAbility {
    private static final int PARTICLE_COLOR = TextColor.m_131268_((String)"#5e8a37").m_131265_();
    private int durationSeconds;

    public NovaDotAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, float radius, float percentAbilityPowerDealt, float knockbackStrengthMultiplier, int durationSeconds) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost, radius, percentAbilityPowerDealt, knockbackStrengthMultiplier);
        this.durationSeconds = durationSeconds;
    }

    public NovaDotAbility() {
    }

    public int getDurationSeconds() {
        return this.durationSeconds;
    }

    @Override
    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            Vec3 pos = context.getSource().getPos().orElse(player.m_20182_());
            List<LivingEntity> targetEntities = this.getTargetEntities(player.f_19853_, (LivingEntity)player, pos);
            float attackDamage = this.getAbilityPower((ServerPlayer)player);
            for (LivingEntity targetEntity : targetEntities) {
                DamageOverTimeHelper.invalidateAll(targetEntity);
                DamageOverTimeHelper.applyDamageOverTime(targetEntity, DamageSource.m_19344_((Player)player), attackDamage, this.getDurationSeconds() * 20);
                targetEntity.m_7292_(new MobEffectInstance(ModEffects.NOVA_DOT, this.getDurationSeconds() * 20, 0, false, true, false));
            }
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    @Override
    protected void doParticles(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> {
            Vec3 pos = context.getSource().getPos().orElse(player.m_20182_());
            AreaEffectCloud areaEffectCloud = new AreaEffectCloud(player.f_19853_, pos.f_82479_, pos.f_82480_, pos.f_82481_);
            areaEffectCloud.m_19718_((LivingEntity)player);
            areaEffectCloud.m_19712_(this.getRadius((Entity)player));
            areaEffectCloud.m_19732_(-0.5f);
            areaEffectCloud.m_19740_(0);
            areaEffectCloud.m_19734_(4);
            areaEffectCloud.m_19722_(Potions.f_43598_);
            areaEffectCloud.m_19738_(-areaEffectCloud.m_19743_() / (float)areaEffectCloud.m_19748_());
            areaEffectCloud.m_19714_(PARTICLE_COLOR);
            areaEffectCloud.m_19724_((ParticleOptions)ModParticles.NOVA_DOT.get());
            player.f_19853_.m_7967_((Entity)areaEffectCloud);
        });
    }

    @Override
    protected void doSound(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> {
            Vec3 pos = context.getSource().getPos().orElse(player.m_20182_());
            player.f_19853_.m_6263_((Player)player, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_12436_, SoundSource.PLAYERS, 0.2f, 1.0f);
            player.m_6330_(SoundEvents.f_12436_, SoundSource.PLAYERS, 0.2f, 1.0f);
        });
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.INT_SEGMENTED_7.writeBits(this.durationSeconds, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.durationSeconds = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.INT.writeNbt(this.durationSeconds).ifPresent(tag -> nbt.m_128365_("durationSeconds", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.durationSeconds = Adapters.INT.readNbt(nbt.m_128423_("durationSeconds")).orElse(0);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.INT.writeJson(this.durationSeconds).ifPresent(element -> json.add("durationSeconds", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.durationSeconds = Adapters.INT.readJson(json.get("durationSeconds")).orElse(0);
    }

    public static class NovaDotEffect
    extends MobEffect {
        public NovaDotEffect(int color, ResourceLocation id) {
            super(MobEffectCategory.HARMFUL, color);
            this.setRegistryName(id);
        }
    }
}

