/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.EntityStunnedEvent;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModSounds;
import iskallia.vault.mana.Mana;
import iskallia.vault.network.message.StunnedParticleMessage;
import iskallia.vault.skill.ability.effect.AbstractShellAbility;
import iskallia.vault.skill.ability.effect.EmpowerAbility;
import iskallia.vault.skill.ability.effect.ShellPorcupineAbility;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.tree.AbilityTree;
import iskallia.vault.world.data.PlayerAbilitiesData;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber
public class ShellAbility
extends AbstractShellAbility {
    private float additionalManaPerHit;
    private float stunChance;
    private int stunDurationTicks;
    private int stunAmplifier;

    public ShellAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCostPerSecond) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCostPerSecond);
    }

    public ShellAbility() {
    }

    @Override
    protected Ability.ActionResult doToggle(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            if (this.isActive()) {
                ModEffects.SHELL.addTo((LivingEntity)player, 0);
                return Ability.ActionResult.successCooldownDeferred();
            }
            player.m_21195_((MobEffect)ModEffects.SHELL);
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    @Override
    protected void doToggleSound(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> {
            if (this.isActive()) {
                player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.SHELL, SoundSource.MASTER, 0.7f, 1.0f);
                player.m_6330_(ModSounds.SHELL, SoundSource.MASTER, 0.7f, 1.0f);
            }
        });
    }

    @Override
    public Ability.TickResult doInactiveTick(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            if (player.m_21023_((MobEffect)ModEffects.SHELL)) {
                player.m_21195_((MobEffect)ModEffects.SHELL);
            }
            return Ability.TickResult.PASS;
        }).orElse(Ability.TickResult.PASS);
    }

    @Override
    protected void doManaDepleted(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(entity -> entity.m_21195_((MobEffect)ModEffects.SHELL));
    }

    @Override
    public void onRemove(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(entity -> entity.m_21195_((MobEffect)ModEffects.SHELL));
    }

    @SubscribeEvent
    public static void onDamage(LivingAttackEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        AbilityTree abilities = PlayerAbilitiesData.get(player.m_183503_()).getAbilities((Player)player);
        abilities.getAll(ShellAbility.class, Ability::isActive).stream().findFirst().ifPresent(ability -> {
            if (player.m_183503_().f_46441_.nextDouble() > (double)ability.stunChance) {
                return;
            }
            Entity patt3912$temp = event.getSource().m_7639_();
            if (patt3912$temp instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)patt3912$temp;
                attacker.m_7292_(new MobEffectInstance(ModEffects.NO_AI, 30, 1, false, false){

                    public boolean m_19552_(LivingEntity livingEntity, Runnable p_19554_) {
                        if (!livingEntity.m_21224_()) {
                            ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new StunnedParticleMessage(new Vec3(livingEntity.m_20185_(), livingEntity.m_20186_() + (double)livingEntity.m_20206_(), livingEntity.m_20189_()), livingEntity.m_20205_()));
                        }
                        return super.m_19552_(livingEntity, p_19554_);
                    }
                });
                CommonEvents.ENTITY_STUNNED.invoke(new EntityStunnedEvent.Data((LivingEntity)player, attacker));
                if (Mana.decrease((Player)player, ability.additionalManaPerHit) <= 0.0f) {
                    player.m_21195_((MobEffect)ModEffects.SHELL);
                    ability.putOnCooldown(SkillContext.of(player));
                    ability.setActive(false);
                }
            }
        });
    }

    public float getStunChance() {
        return this.stunChance;
    }

    public int getStunDurationSeconds() {
        return this.stunDurationTicks / 20;
    }

    public int getStunAmplifier() {
        return this.stunAmplifier;
    }

    public float getAdditionalManaPerHit() {
        return this.additionalManaPerHit;
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.additionalManaPerHit), buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.stunChance), buffer);
        Adapters.INT_SEGMENTED_7.writeBits(this.stunDurationTicks, buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.stunAmplifier, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.additionalManaPerHit = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.stunChance = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.stunDurationTicks = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
        this.stunAmplifier = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.additionalManaPerHit)).ifPresent(tag -> nbt.m_128365_("additionalManaPerHit", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.stunChance)).ifPresent(tag -> nbt.m_128365_("stunChance", tag));
            Adapters.INT.writeNbt(this.stunDurationTicks).ifPresent(tag -> nbt.m_128365_("stunDurationTicks", tag));
            Adapters.INT.writeNbt(this.stunAmplifier).ifPresent(tag -> nbt.m_128365_("stunAmplifier", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.additionalManaPerHit = Adapters.FLOAT.readNbt(nbt.m_128423_("additionalManaPerHit")).orElse(Float.valueOf(0.0f)).floatValue();
        this.stunChance = Adapters.FLOAT.readNbt(nbt.m_128423_("stunChance")).orElse(Float.valueOf(0.0f)).floatValue();
        this.stunDurationTicks = Adapters.INT.readNbt(nbt.m_128423_("stunDurationTicks")).orElse(0);
        this.stunAmplifier = Adapters.INT.readNbt(nbt.m_128423_("stunAmplifier")).orElse(0);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.additionalManaPerHit)).ifPresent(element -> json.add("additionalManaPerHit", element));
            Adapters.FLOAT.writeJson(Float.valueOf(this.stunChance)).ifPresent(element -> json.add("stunChance", element));
            Adapters.INT.writeJson(this.stunDurationTicks).ifPresent(element -> json.add("stunDurationTicks", element));
            Adapters.INT.writeJson(this.stunAmplifier).ifPresent(element -> json.add("stunAmplifier", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.additionalManaPerHit = Adapters.FLOAT.readJson(json.get("additionalManaPerHit")).orElse(Float.valueOf(0.0f)).floatValue();
        this.stunChance = Adapters.FLOAT.readJson(json.get("stunChance")).orElse(Float.valueOf(0.0f)).floatValue();
        this.stunDurationTicks = Adapters.INT.readJson(json.get("stunDurationTicks")).orElse(0);
        this.stunAmplifier = Adapters.INT.readJson(json.get("stunAmplifier")).orElse(0);
    }

    public static class ShellEffect
    extends EmpowerAbility.EmpowerEffect {
        public ShellEffect(int color, ResourceLocation resourceLocation) {
            super(ShellPorcupineAbility.class, color, resourceLocation);
        }
    }
}

