/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModSounds;
import iskallia.vault.mana.Mana;
import iskallia.vault.skill.ability.effect.AbstractShellAbility;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.ability.effect.spi.core.ToggleAbilityEffect;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.tree.AbilityTree;
import iskallia.vault.util.calc.PlayerStat;
import iskallia.vault.world.data.PlayerAbilitiesData;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;

public class ShellPorcupineAbility
extends AbstractShellAbility {
    private float additionalDurabilityWearReduction;
    private float additionalThornsDamagePercent;
    private float additionalManaPerHit;

    public ShellPorcupineAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCostPerSecond, float additionalDurabilityWearReduction, float additionalThornsDamagePercent, float additionalManaPerHit) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCostPerSecond);
        this.additionalDurabilityWearReduction = additionalDurabilityWearReduction;
        this.additionalThornsDamagePercent = additionalThornsDamagePercent;
        this.additionalManaPerHit = additionalManaPerHit;
    }

    public ShellPorcupineAbility() {
    }

    public float getAdditionalDurabilityWearReduction() {
        return this.additionalDurabilityWearReduction;
    }

    public float getAdditionalThornsDamagePercent() {
        return this.additionalThornsDamagePercent;
    }

    public float getAdditionalManaPerHit() {
        return this.additionalManaPerHit;
    }

    private static List<ShellPorcupineAbility> getAll(LivingEntity livingEntity) {
        ServerPlayer player;
        ArrayList<ShellPorcupineAbility> result = new ArrayList<ShellPorcupineAbility>();
        if (!(livingEntity instanceof ServerPlayer) || (player = (ServerPlayer)livingEntity).m_21220_().stream().noneMatch(e -> e.m_19544_() instanceof ShellPorcupineEffect)) {
            return result;
        }
        AbilityTree abilities = PlayerAbilitiesData.get(player.m_183503_()).getAbilities((Player)player);
        return abilities.getAll(ShellPorcupineAbility.class, Skill::isUnlocked);
    }

    @Override
    protected Ability.ActionResult doToggle(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            if (this.isActive()) {
                ModEffects.SHELL_PORCUPINE.addTo((LivingEntity)player, 0);
                return Ability.ActionResult.successCooldownDeferred();
            }
            player.m_21195_((MobEffect)ModEffects.SHELL_PORCUPINE);
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    @Override
    protected void doToggleSound(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> {
            if (this.isActive()) {
                player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.SHELL_PORCUPINE, SoundSource.MASTER, 0.7f, 1.0f);
                player.m_6330_(ModSounds.SHELL_PORCUPINE, SoundSource.MASTER, 0.7f, 1.0f);
            }
        });
    }

    @Override
    public Ability.TickResult doInactiveTick(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            if (player.m_21023_((MobEffect)ModEffects.SHELL_PORCUPINE)) {
                player.m_21195_((MobEffect)ModEffects.SHELL_PORCUPINE);
            }
            return Ability.TickResult.PASS;
        }).orElse(Ability.TickResult.PASS);
    }

    @Override
    protected void doManaDepleted(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(entity -> entity.m_21195_((MobEffect)ModEffects.SHELL_PORCUPINE));
    }

    @Override
    public void onRemove(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(entity -> entity.m_21195_((MobEffect)ModEffects.SHELL_PORCUPINE));
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.additionalDurabilityWearReduction), buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.additionalThornsDamagePercent), buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.additionalManaPerHit), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.additionalDurabilityWearReduction = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.additionalThornsDamagePercent = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.additionalManaPerHit = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.additionalDurabilityWearReduction)).ifPresent(tag -> nbt.m_128365_("additionalDurabilityWearReduction", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.additionalThornsDamagePercent)).ifPresent(tag -> nbt.m_128365_("additionalThornsDamagePercent", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.additionalManaPerHit)).ifPresent(tag -> nbt.m_128365_("additionalManaPerHit", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.additionalDurabilityWearReduction = Adapters.FLOAT.readNbt(nbt.m_128423_("additionalDurabilityWearReduction")).orElse(Float.valueOf(0.0f)).floatValue();
        this.additionalThornsDamagePercent = Adapters.FLOAT.readNbt(nbt.m_128423_("additionalThornsDamagePercent")).orElse(Float.valueOf(0.0f)).floatValue();
        this.additionalManaPerHit = Adapters.FLOAT.readNbt(nbt.m_128423_("additionalManaPerHit")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.additionalDurabilityWearReduction)).ifPresent(element -> json.add("additionalDurabilityWearReduction", element));
            Adapters.FLOAT.writeJson(Float.valueOf(this.additionalThornsDamagePercent)).ifPresent(element -> json.add("additionalThornsDamagePercent", element));
            Adapters.FLOAT.writeJson(Float.valueOf(this.additionalManaPerHit)).ifPresent(element -> json.add("additionalManaPerHit", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.additionalDurabilityWearReduction = Adapters.FLOAT.readJson(json.get("additionalDurabilityWearReduction")).orElse(Float.valueOf(0.0f)).floatValue();
        this.additionalThornsDamagePercent = Adapters.FLOAT.readJson(json.get("additionalThornsDamagePercent")).orElse(Float.valueOf(0.0f)).floatValue();
        this.additionalManaPerHit = Adapters.FLOAT.readJson(json.get("additionalManaPerHit")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    static {
        CommonEvents.PLAYER_STAT.of(PlayerStat.DURABILITY_WEAR_REDUCTION).register(ShellPorcupineAbility.class, data -> ShellPorcupineAbility.getAll(data.getEntity()).forEach(skill -> data.setValue(data.getValue() + skill.getAdditionalDurabilityWearReduction())));
        CommonEvents.PLAYER_STAT.of(PlayerStat.THORNS_DAMAGE_FLAT).register(ShellPorcupineAbility.class, data -> ShellPorcupineAbility.getAll(data.getEntity()).forEach(skill -> {
            ServerPlayer player;
            data.setValue(data.getValue() + data.getValue() * skill.getAdditionalThornsDamagePercent());
            LivingEntity patt1900$temp = data.getEntity();
            if (patt1900$temp instanceof ServerPlayer && Mana.decrease((Player)(player = (ServerPlayer)patt1900$temp), skill.getAdditionalManaPerHit()) <= 0.0f) {
                player.m_21195_((MobEffect)ModEffects.SHELL_PORCUPINE);
                skill.putOnCooldown(SkillContext.of(player));
                skill.setActive(false);
            }
        }));
    }

    public static class ShellPorcupineEffect
    extends ToggleAbilityEffect {
        public ShellPorcupineEffect(int color, ResourceLocation resourceLocation) {
            this(ShellPorcupineAbility.class, color, resourceLocation);
        }

        public ShellPorcupineEffect(Class<?> type, int color, ResourceLocation resourceLocation) {
            super(type, color, resourceLocation);
            this.m_19472_(Attributes.f_22278_, Mth.m_14062_((Random)new Random(resourceLocation.hashCode())).toString(), 0.01, AttributeModifier.Operation.ADDITION);
        }
    }
}

