/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.entity.entity.EternalEntity;
import iskallia.vault.event.ActiveFlags;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModSounds;
import iskallia.vault.mana.Mana;
import iskallia.vault.skill.ability.effect.ShellAbility;
import iskallia.vault.skill.ability.effect.ShellPorcupineAbility;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.util.EntityHelper;
import iskallia.vault.util.calc.ThornsHelper;
import iskallia.vault.util.damage.ThornsReflectDamageSource;
import iskallia.vault.world.data.PlayerAbilitiesData;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ShellQuillAbility
extends ShellPorcupineAbility {
    private int quillCount;

    public ShellQuillAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCostPerSecond, float additionalDurabilityWearReduction, float additionalThornsDamagePercent, float additionalManaPerHit, int quillCount) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCostPerSecond, additionalDurabilityWearReduction, additionalThornsDamagePercent, additionalManaPerHit);
        this.quillCount = quillCount;
    }

    public ShellQuillAbility() {
    }

    public int getQuillCount() {
        return this.quillCount;
    }

    @Override
    protected Ability.ActionResult doToggle(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            if (this.isActive()) {
                ModEffects.SHELL_QUILL.addTo((LivingEntity)player, 0);
                return Ability.ActionResult.successCooldownDeferred();
            }
            player.m_21195_((MobEffect)ModEffects.SHELL_QUILL);
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    @Override
    protected void doToggleSound(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> {
            if (this.isActive()) {
                player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.SHELL_QUILL, SoundSource.MASTER, 0.7f, 1.0f);
                player.m_6330_(ModSounds.SHELL_QUILL, SoundSource.MASTER, 0.7f, 1.0f);
            }
        });
    }

    @Override
    public Ability.TickResult doInactiveTick(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            if (player.m_21023_((MobEffect)ModEffects.SHELL_QUILL)) {
                player.m_21195_((MobEffect)ModEffects.SHELL_QUILL);
            }
            return Ability.TickResult.PASS;
        }).orElse(Ability.TickResult.PASS);
    }

    @Override
    protected void doManaDepleted(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(entity -> entity.m_21195_((MobEffect)ModEffects.SHELL_QUILL));
    }

    @Override
    public void onRemove(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(entity -> entity.m_21195_((MobEffect)ModEffects.SHELL_QUILL));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void thornsReflectDamage(LivingAttackEvent event) {
        Entity entity;
        if (event.getSource() instanceof ThornsReflectDamageSource || ActiveFlags.IS_THORNS_REFLECTING.isSet()) {
            return;
        }
        Entity source = event.getSource().m_7639_();
        if (!(source instanceof LivingEntity) || !((entity = event.getEntity()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        PlayerAbilitiesData.get(player.m_183503_()).getAbilities((Player)player).getAll(ShellQuillAbility.class, Ability::isActive).stream().findFirst().ifPresent(ability -> ActiveFlags.IS_AOE_ATTACKING.runIfNotSet(() -> {
            ActiveFlags.IS_THORNS_REFLECTING.push();
            float reflectedDamage = 0.0f;
            float dmg = (float)player.m_21133_(Attributes.f_22281_);
            float thornsMultiplier = ThornsHelper.getThornsDamageMultiplier((LivingEntity)player);
            if (thornsMultiplier > 0.0f) {
                reflectedDamage += dmg * thornsMultiplier;
            }
            float additionalThornsDamage = ThornsHelper.getAdditionalThornsFlatDamage((LivingEntity)player);
            ShellQuillAbility.doQuill((Player)player, reflectedDamage += additionalThornsDamage, ability.getQuillCount());
            if (Mana.decrease((Player)player, ability.getAdditionalManaPerHit()) <= 0.0f) {
                player.m_21195_((MobEffect)ModEffects.SHELL_QUILL);
                ability.putOnCooldown(SkillContext.of(player));
                ability.setActive(false);
            }
        }));
    }

    private static void doQuill(Player player, float reflectedDamage, int quillCount) {
        List<Mob> nearby = EntityHelper.getNearby((LevelAccessor)player.m_183503_(), (Vec3i)player.m_142538_(), 5.0f, Mob.class);
        nearby.removeIf(mob -> mob instanceof EternalEntity);
        if (!nearby.isEmpty()) {
            nearby.sort(Comparator.comparing(e -> Float.valueOf(e.m_20270_((Entity)player))));
            nearby = nearby.subList(0, Math.min(quillCount, nearby.size()));
            float multiplier = 0.5f;
            for (Mob mob2 : nearby) {
                Vec3 movement = mob2.m_20184_();
                mob2.m_6469_((DamageSource)ThornsReflectDamageSource.of((Entity)player), reflectedDamage * multiplier);
                mob2.m_20256_(movement);
                multiplier *= 0.5f;
            }
        }
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.quillCount, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.quillCount = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.INT.writeNbt(this.quillCount).ifPresent(tag -> nbt.m_128365_("quillCount", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.quillCount = Adapters.INT.readNbt(nbt.m_128423_("quillCount")).orElse(0);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.INT.writeJson(this.quillCount).ifPresent(element -> json.add("quillCount", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.quillCount = Adapters.INT.readJson(json.get("quillCount")).orElse(0);
    }

    public static class ShellQuillEffect
    extends ShellPorcupineAbility.ShellPorcupineEffect {
        public ShellQuillEffect(int color, ResourceLocation resourceLocation) {
            super(ShellAbility.class, color, resourceLocation);
            this.m_19472_(Attributes.f_22278_, Mth.m_14062_((Random)new Random(resourceLocation.hashCode())).toString(), 0.01, AttributeModifier.Operation.ADDITION);
        }
    }
}

