/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import iskallia.vault.entity.entity.EternalEntity;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.StonefallParticleMessage;
import iskallia.vault.skill.ability.effect.spi.AbstractStonefallAbility;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.tree.AbilityTree;
import iskallia.vault.util.EntityHelper;
import iskallia.vault.world.data.PlayerAbilitiesData;
import java.util.List;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="the_vault", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class StonefallAbility
extends AbstractStonefallAbility {
    public StonefallAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, int durationTicks, float knockbackMultiplier, float radius, float damageReduction) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost, durationTicks, knockbackMultiplier, radius, damageReduction);
    }

    public StonefallAbility() {
    }

    @Override
    protected boolean canDoAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> !player.m_21023_(ModEffects.STONEFALL) && super.canDoAction(context)).orElse(false);
    }

    @Override
    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            player.m_7292_(new MobEffectInstance(ModEffects.STONEFALL, this.getDurationTicks(), 0, false, false, true));
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    @SubscribeEvent
    public static void on(LivingFallEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        MobEffectInstance effectInstance = player.m_21124_(ModEffects.STONEFALL);
        if (effectInstance == null) {
            return;
        }
        float dist = event.getDistance();
        Level level = player.f_19853_;
        if (dist < 3.0f) {
            return;
        }
        AbilityTree abilities = PlayerAbilitiesData.get((ServerLevel)player.f_19853_).getAbilities((Player)player);
        for (StonefallAbility ability : abilities.getAll(StonefallAbility.class, Skill::isUnlocked)) {
            float radius = ability.getRadius((Entity)player) + Mth.m_14036_((float)(dist / 3.75f), (float)0.0f, (float)8.0f);
            List<LivingEntity> nearby = EntityHelper.getNearby((LevelAccessor)level, (Vec3i)player.m_142538_(), radius, LivingEntity.class);
            nearby.removeIf(mob -> mob instanceof EternalEntity || mob instanceof ServerPlayer);
            nearby.forEach(mob -> {
                float distTo = mob.m_20270_((Entity)player);
                float knockbackStrength = Mth.m_14036_((float)(dist / (12.0f + distTo)), (float)0.75f, (float)2.5f) * ability.getKnockbackMultiplier();
                EntityHelper.knockbackWithStrength(mob, (LivingEntity)player, knockbackStrength);
            });
            event.setDamageMultiplier(Mth.m_14036_((float)(1.0f - ability.getDamageReduction()), (float)0.0f, (float)1.0f));
            ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new StonefallParticleMessage(new Vec3(player.m_20185_(), player.m_20186_() + (double)0.15f, player.m_20189_()), radius));
            player.f_19853_.m_6263_((Player)player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 0.1f, 0.75f);
            player.m_6330_(SoundEvents.f_11913_, SoundSource.PLAYERS, 0.1f, 0.75f);
        }
    }

    public static class StonefallEffect
    extends MobEffect {
        public StonefallEffect(int color, ResourceLocation resourceLocation) {
            super(MobEffectCategory.BENEFICIAL, color);
            this.setRegistryName(resourceLocation);
        }
    }
}

