/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.entity.entity.VaultStormArrow;
import iskallia.vault.skill.ability.effect.spi.AbstractStormArrowAbility;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.base.SkillContext;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;

public class StormArrowBlizzardAbility
extends AbstractStormArrowAbility {
    private int slowDuration;
    private int frostbiteDuration;
    private int amplifier;
    private int intervalHypothermiaTicks;
    private float frostbiteChance;

    public StormArrowBlizzardAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, float percentAttackDamageDealt, float radius, int duration, int intervalTicks, int slowDuration, int frostbiteDuration, int amplifier, int intervalHypothermiaTicks, float frostbiteChance) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost, percentAttackDamageDealt, radius, duration, intervalTicks);
        this.slowDuration = slowDuration;
        this.frostbiteDuration = frostbiteDuration;
        this.amplifier = amplifier;
        this.intervalHypothermiaTicks = intervalHypothermiaTicks;
        this.frostbiteChance = frostbiteChance;
    }

    public StormArrowBlizzardAbility() {
    }

    public int getSlowDuration() {
        return this.slowDuration;
    }

    public int getFrostbiteDuration() {
        return this.frostbiteDuration;
    }

    public int getAmplifier() {
        return this.amplifier;
    }

    public int getIntervalHypothermiaTicks() {
        return this.intervalHypothermiaTicks;
    }

    public float getFrostbiteChance() {
        return this.frostbiteChance;
    }

    @Override
    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            VaultStormArrow arrow = new VaultStormArrow(player.f_19853_, (LivingEntity)player);
            arrow.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.0f, 0.0f);
            arrow.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
            arrow.setType("blizzard");
            arrow.setDuration(this.getDuration());
            arrow.setRadius(this.getRadius((Entity)player));
            arrow.setIntervalTicks(this.getIntervalTicks());
            arrow.setAbilityPowerPercent(this.getPercentAbilityPowerDealt());
            arrow.setSlowDuration(this.getSlowDuration());
            arrow.setFrostbiteDuration(this.getFrostbiteDuration());
            arrow.setAmplifier(this.getAmplifier());
            arrow.setIntervalHypothermiaTicks(this.getIntervalHypothermiaTicks());
            arrow.setFrostbiteChance(this.getFrostbiteChance());
            player.f_19853_.m_7967_((Entity)arrow);
            player.f_19853_.m_6269_((Player)null, (Entity)player, SoundEvents.f_11847_, SoundSource.PLAYERS, 1.0f, 1.25f);
            return Ability.ActionResult.successCooldownDelayed(this.getDuration());
        }).orElse(Ability.ActionResult.fail());
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.frostbiteChance), buffer);
        Adapters.INT.writeBits(this.slowDuration, buffer);
        Adapters.INT.writeBits(this.frostbiteDuration, buffer);
        Adapters.INT.writeBits(this.amplifier, buffer);
        Adapters.INT.writeBits(this.intervalHypothermiaTicks, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.frostbiteChance = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.slowDuration = (Integer)Adapters.INT.readBits(buffer).orElseThrow();
        this.frostbiteDuration = (Integer)Adapters.INT.readBits(buffer).orElseThrow();
        this.amplifier = (Integer)Adapters.INT.readBits(buffer).orElseThrow();
        this.intervalHypothermiaTicks = (Integer)Adapters.INT.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.frostbiteChance)).ifPresent(tag -> nbt.m_128365_("frostbiteChance", tag));
            Adapters.INT.writeNbt(this.slowDuration).ifPresent(tag -> nbt.m_128365_("slowDuration", tag));
            Adapters.INT.writeNbt(this.frostbiteDuration).ifPresent(tag -> nbt.m_128365_("frostbiteDuration", tag));
            Adapters.INT.writeNbt(this.amplifier).ifPresent(tag -> nbt.m_128365_("amplifier", tag));
            Adapters.INT.writeNbt(this.intervalHypothermiaTicks).ifPresent(tag -> nbt.m_128365_("intervalHypothermiaTicks", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.frostbiteChance = Adapters.FLOAT.readNbt(nbt.m_128423_("frostbiteChance")).orElse(Float.valueOf(0.05f)).floatValue();
        this.slowDuration = Adapters.INT.readNbt(nbt.m_128423_("slowDuration")).orElse(200);
        this.frostbiteDuration = Adapters.INT.readNbt(nbt.m_128423_("frostbiteDuration")).orElse(30);
        this.amplifier = Adapters.INT.readNbt(nbt.m_128423_("amplifier")).orElse(20);
        this.intervalHypothermiaTicks = Adapters.INT.readNbt(nbt.m_128423_("intervalHypothermiaTicks")).orElse(60);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.frostbiteChance)).ifPresent(element -> json.add("frostbiteChance", element));
            Adapters.INT.writeJson(this.slowDuration).ifPresent(element -> json.add("slowDuration", element));
            Adapters.INT.writeJson(this.frostbiteDuration).ifPresent(element -> json.add("frostbiteDuration", element));
            Adapters.INT.writeJson(this.amplifier).ifPresent(element -> json.add("amplifier", element));
            Adapters.INT.writeJson(this.intervalHypothermiaTicks).ifPresent(element -> json.add("intervalHypothermiaTicks", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.frostbiteChance = Adapters.FLOAT.readJson(json.get("frostbiteChance")).orElse(Float.valueOf(0.05f)).floatValue();
        this.slowDuration = Adapters.INT.readJson(json.get("slowDuration")).orElse(200);
        this.frostbiteDuration = Adapters.INT.readJson(json.get("frostbiteDuration")).orElse(30);
        this.amplifier = Adapters.INT.readJson(json.get("amplifier")).orElse(20);
        this.intervalHypothermiaTicks = Adapters.INT.readJson(json.get("intervalHypothermiaTicks")).orElse(60);
    }
}

