/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.entity.VaultBoss;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModSounds;
import iskallia.vault.skill.ability.effect.spi.AbstractTauntAbility;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.util.AABBHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="the_vault", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TauntAbility
extends AbstractTauntAbility {
    protected static final Predicate<LivingEntity> MONSTER_PREDICATE = entity -> entity.m_6095_().m_20674_() == MobCategory.MONSTER && !(entity instanceof VaultBoss);
    private int amplifier;

    public TauntAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, float radius, int durationTicks, int amplifier) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost, radius, durationTicks);
        this.amplifier = amplifier;
    }

    public TauntAbility() {
    }

    public int getAmplifier() {
        return this.amplifier;
    }

    @Override
    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            player.m_21195_(ModEffects.TAUNT);
            player.m_7292_(new MobEffectInstance(ModEffects.TAUNT, this.getDurationTicks(), 0, false, false, true));
            float radius = this.getRadius((Player)player);
            List nearbyMobs = player.f_19853_.m_45971_(Mob.class, TargetingConditions.m_148352_().m_26883_((double)radius).m_26888_(MONSTER_PREDICATE), (LivingEntity)player, AABBHelper.create(player.m_20182_(), radius));
            List<BlockPos> candidateTeleportPositionList = this.getCandidateTeleportPositionList((ServerPlayer)player, 2, 8);
            for (Mob mob : nearbyMobs) {
                if (!player.m_142582_((Entity)mob)) continue;
                mob.m_6710_((LivingEntity)player);
                mob.m_21195_(ModEffects.TARGET_OVERRIDE);
                MobEffect effect = ModEffects.TARGET_OVERRIDE;
                if (effect instanceof TargetOverrideEffect) {
                    TargetOverrideEffect overrideEffect = (TargetOverrideEffect)effect;
                    overrideEffect.setTauntingPlayer((Player)player);
                }
                mob.m_7292_(new MobEffectInstance(effect, this.getDurationTicks(), 0, false, false));
                mob.m_7292_(new MobEffectInstance(ModEffects.VULNERABLE, this.getDurationTicks(), this.getAmplifier(), false, false){});
                mob.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
                mob.m_21573_().m_26573_();
                this.sortByShortestDistanceTo(candidateTeleportPositionList, player.m_142538_(), mob.m_20097_());
                BlockPos validTeleportPosition = this.getValidTeleportPosition(candidateTeleportPositionList, player.f_19853_, mob.m_142469_());
                if (validTeleportPosition == null) continue;
                mob.m_6034_((double)validTeleportPosition.m_123341_(), (double)validTeleportPosition.m_123342_(), (double)validTeleportPosition.m_123343_());
            }
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    protected List<BlockPos> getCandidateTeleportPositionList(ServerPlayer player, int minRadius, int maxRadius) {
        int minRadiusSqr = minRadius * minRadius;
        int maxRadiusSqr = maxRadius * maxRadius;
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        for (int x = -maxRadius; x <= maxRadius; ++x) {
            for (int y = -maxRadius; y <= maxRadius; ++y) {
                for (int z = -maxRadius; z <= maxRadius; ++z) {
                    int distanceSqr = x * x + y * y + z * z;
                    if (distanceSqr < minRadiusSqr || distanceSqr > maxRadiusSqr) continue;
                    result.add(new BlockPos(player.m_20185_() + (double)x, player.m_20186_() + (double)y, player.m_20189_() + (double)z));
                }
            }
        }
        return result;
    }

    protected void sortByShortestDistanceTo(List<BlockPos> candidateTeleportPositionList, BlockPos playerBlockPos, BlockPos mobBlockPos) {
        candidateTeleportPositionList.sort(Comparator.comparingLong(pos -> {
            long px = playerBlockPos.m_123341_() - pos.m_123341_();
            long py = playerBlockPos.m_123342_() - pos.m_123342_();
            long pz = playerBlockPos.m_123343_() - pos.m_123343_();
            long mx = mobBlockPos.m_123341_() - pos.m_123341_();
            long my = mobBlockPos.m_123342_() - pos.m_123342_();
            long mz = mobBlockPos.m_123343_() - pos.m_123343_();
            return px * px + py * py + pz * pz + mx * mx + my * my + mz * mz;
        }));
    }

    @Nullable
    protected BlockPos getValidTeleportPosition(List<BlockPos> candidateTeleportPositionList, Level level, AABB boundingBox) {
        for (BlockPos blockPos : candidateTeleportPositionList) {
            AABB adjustedAABB = AABB.m_165882_((Vec3)Vec3.f_82478_, (double)boundingBox.m_82362_(), (double)boundingBox.m_82376_(), (double)boundingBox.m_82385_()).m_82338_(blockPos);
            if (this.isCollidingWithBlock(level, adjustedAABB)) continue;
            return blockPos;
        }
        return null;
    }

    protected boolean isCollidingWithBlock(Level level, AABB boundingBox) {
        HashSet validBlockStateSet = Sets.newHashSet((Object[])new BlockState[]{Blocks.f_50016_.m_49966_(), Blocks.f_49990_.m_49966_()});
        BlockPos blockPosMin = new BlockPos(boundingBox.f_82288_ + 0.001, boundingBox.f_82289_ + 0.001, boundingBox.f_82290_ + 0.001);
        BlockPos blockPosMax = new BlockPos(boundingBox.f_82291_ - 0.001, boundingBox.f_82292_ - 0.001, boundingBox.f_82293_ - 0.001);
        if (level.m_46832_(blockPosMin, blockPosMax)) {
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (int x = blockPosMin.m_123341_(); x <= blockPosMax.m_123341_(); ++x) {
                for (int y = blockPosMin.m_123342_(); y <= blockPosMax.m_123342_(); ++y) {
                    for (int z = blockPosMin.m_123343_(); z <= blockPosMax.m_123343_(); ++z) {
                        if (validBlockStateSet.contains(level.m_8055_((BlockPos)pos.m_122178_(x, y, z)))) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    protected void doParticles(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> {
            float radius = this.getRadius((Player)player);
            int particleCount = (int)Mth.m_14008_((double)(Math.pow(radius, 2.0) * 3.1415927410125732 * 100.0), (double)50.0, (double)400.0);
            ((ServerLevel)player.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123762_, player.m_20185_(), player.m_20186_(), player.m_20189_(), particleCount / 2, (double)radius * 0.5, 0.5, (double)radius * 0.5, 0.0);
            ((ServerLevel)player.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123792_, player.m_20185_(), player.m_20186_(), player.m_20189_(), particleCount / 8, (double)radius * 0.5, 0.5, (double)radius * 0.5, 0.0);
            AreaEffectCloud areaEffectCloud = new AreaEffectCloud(player.f_19853_, player.m_20185_(), player.m_20186_(), player.m_20189_());
            areaEffectCloud.m_19718_((LivingEntity)player);
            areaEffectCloud.m_19712_(radius);
            areaEffectCloud.m_19732_(-0.5f);
            areaEffectCloud.m_19740_(0);
            areaEffectCloud.m_19734_(4);
            areaEffectCloud.m_19722_(Potions.f_43598_);
            areaEffectCloud.m_19738_(-areaEffectCloud.m_19743_() / (float)areaEffectCloud.m_19748_());
            areaEffectCloud.m_19714_(Color.RED.getRGB());
            areaEffectCloud.m_19724_((ParticleOptions)ParticleTypes.f_123762_);
            player.f_19853_.m_7967_((Entity)areaEffectCloud);
        });
    }

    @Override
    protected void doSound(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> {
            player.f_19853_.m_6263_((Player)player, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.TAUNT, SoundSource.PLAYERS, 0.4f, 1.0f);
            player.m_6330_(ModSounds.TAUNT, SoundSource.PLAYERS, 0.4f, 1.0f);
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void on(LivingHurtEvent event) {
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.INT.writeBits(this.amplifier, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.amplifier = (Integer)Adapters.INT.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.INT.writeNbt(this.amplifier).ifPresent(tag -> nbt.m_128365_("amplifier", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.amplifier = Adapters.INT.readNbt(nbt.m_128423_("amplifier")).orElse(0);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.INT.writeJson(this.amplifier).ifPresent(element -> json.add("amplifier", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.amplifier = Adapters.INT.readJson(json.get("amplifier")).orElse(0);
    }

    public static class TargetOverrideEffect
    extends MobEffect {
        private static final int RANGE = 128;
        private Player tauntingPlayer = null;

        public TargetOverrideEffect(int color, ResourceLocation resourceLocation) {
            super(MobEffectCategory.NEUTRAL, color);
            this.setRegistryName(resourceLocation);
        }

        public void setTauntingPlayer(Player tauntingPlayer) {
            this.tauntingPlayer = tauntingPlayer;
        }

        public Player getTauntingPlayer() {
            return this.tauntingPlayer;
        }

        public boolean m_6584_(int duration, int amplifier) {
            return duration % 10 == 0;
        }

        public void m_6742_(@Nonnull LivingEntity livingEntity, int amplifier) {
            if (!(livingEntity instanceof Mob)) {
                return;
            }
            Mob mob = (Mob)livingEntity;
            Player nearestPlayer = livingEntity.f_19853_.m_45946_(TargetingConditions.m_148353_().m_26883_(128.0).m_26888_(entity -> entity.m_21023_(ModEffects.TAUNT)), livingEntity);
            if (nearestPlayer != null) {
                mob.m_6710_((LivingEntity)nearestPlayer);
            }
        }
    }

    public static class TauntEffect
    extends MobEffect {
        public TauntEffect(int color, ResourceLocation resourceLocation) {
            super(MobEffectCategory.NEUTRAL, color);
            this.setRegistryName(resourceLocation);
        }
    }
}

