/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import iskallia.vault.block.entity.TotemPlayerHealthTileEntity;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModEffects;
import iskallia.vault.skill.ability.effect.spi.AbstractTotemAbility;
import iskallia.vault.util.calc.TotemDurationHelper;
import iskallia.vault.util.calc.TotemEffectRadiusHelper;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;

public class TotemAbility
extends AbstractTotemAbility<TotemPlayerHealthTileEntity> {
    private float totemHealthPerSecond;

    public TotemAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, int totemDurationTicks, float totemEffectRadius, float totemHealthPerSecond) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost, totemDurationTicks, totemEffectRadius);
        this.totemHealthPerSecond = totemHealthPerSecond;
    }

    public TotemAbility() {
    }

    @Override
    @Nonnull
    protected BlockState getTotemForPlacement() {
        return ModBlocks.TOTEM_PLAYER_HEALTH.m_49966_();
    }

    @Override
    protected Class<TotemPlayerHealthTileEntity> getTotemTileEntityClass() {
        return TotemPlayerHealthTileEntity.class;
    }

    @Override
    protected void initializeTotem(TotemPlayerHealthTileEntity totem, ServerPlayer player) {
        totem.initialize(player.m_142081_(), TotemDurationHelper.adjustTotemDurationTicks(player, this.getTotemDurationTicks()), TotemEffectRadiusHelper.adjustTotemEffectRadiusHelper(player, this.getTotemEffectRadius((Player)player)), this.totemHealthPerSecond);
    }

    public float getTotemHealthPerSecond() {
        return this.totemHealthPerSecond;
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.totemHealthPerSecond), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.totemHealthPerSecond = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.totemHealthPerSecond)).ifPresent(tag -> nbt.m_128365_("totemHealthPerSecond", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.totemHealthPerSecond = Adapters.FLOAT.readNbt(nbt.m_128423_("totemHealthPerSecond")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.totemHealthPerSecond)).ifPresent(element -> json.add("totemHealthPerSecond", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.totemHealthPerSecond = Adapters.FLOAT.readJson(json.get("totemHealthPerSecond")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public static class TotemPlayerHealthMobEffectInstance
    extends MobEffectInstance {
        private final float healthPerTick;

        public TotemPlayerHealthMobEffectInstance(MobEffect pEffect, int pDuration, int pAmplifier, boolean pAmbient, boolean pVisible, boolean pShowIcon, float healthPerTick) {
            super(pEffect, pDuration, pAmplifier, pAmbient, pVisible, pShowIcon);
            this.healthPerTick = healthPerTick;
        }
    }

    public static class TotemPlayerHealthEffect
    extends MobEffect {
        public TotemPlayerHealthEffect(int color, ResourceLocation resourceLocation) {
            super(MobEffectCategory.BENEFICIAL, color);
            this.setRegistryName(resourceLocation);
        }

        public static void addTo(LivingEntity livingEntity, float healthPerTick) {
            livingEntity.m_7292_(TotemPlayerHealthEffect.instance(healthPerTick));
        }

        private static MobEffectInstance instance(float healthPerTick) {
            return new TotemPlayerHealthMobEffectInstance(ModEffects.TOTEM_PLAYER_HEALTH, 5, 0, false, false, true, healthPerTick);
        }

        public boolean m_6584_(int duration, int amplifier) {
            return true;
        }

        public void m_6742_(@Nonnull LivingEntity livingEntity, int amplifier) {
            if (!(livingEntity instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (player.m_21223_() >= player.m_21233_()) {
                return;
            }
            MobEffectInstance mobEffectInstance = player.m_21124_((MobEffect)this);
            if (!(mobEffectInstance instanceof TotemPlayerHealthMobEffectInstance)) {
                return;
            }
            TotemPlayerHealthMobEffectInstance effectInstance = (TotemPlayerHealthMobEffectInstance)mobEffectInstance;
            player.m_5634_(effectInstance.healthPerTick);
        }
    }
}

