/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import iskallia.vault.block.entity.TotemManaRegenTileEntity;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.init.ModAttributes;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModEffects;
import iskallia.vault.skill.ability.effect.spi.AbstractTotemAbility;
import iskallia.vault.util.calc.TotemDurationHelper;
import iskallia.vault.util.calc.TotemEffectRadiusHelper;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;

public class TotemManaRegenAbility
extends AbstractTotemAbility<TotemManaRegenTileEntity> {
    private float totemManaRegenPercent;

    public TotemManaRegenAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, int totemDurationTicks, float totemEffectRadius, float totemManaRegenPercent) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost, totemDurationTicks, totemEffectRadius);
        this.totemManaRegenPercent = totemManaRegenPercent;
    }

    public TotemManaRegenAbility() {
    }

    public float getTotemManaRegenPercent() {
        return this.totemManaRegenPercent;
    }

    @Override
    @Nonnull
    protected BlockState getTotemForPlacement() {
        return ModBlocks.TOTEM_MANA_REGEN.m_49966_();
    }

    @Override
    protected Class<TotemManaRegenTileEntity> getTotemTileEntityClass() {
        return TotemManaRegenTileEntity.class;
    }

    @Override
    protected void initializeTotem(TotemManaRegenTileEntity totem, ServerPlayer player) {
        totem.initialize(player.m_142081_(), TotemDurationHelper.adjustTotemDurationTicks(player, this.getTotemDurationTicks()), TotemEffectRadiusHelper.adjustTotemEffectRadiusHelper(player, this.getTotemEffectRadius((Player)player)), this.getTotemManaRegenPercent());
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.totemManaRegenPercent), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.totemManaRegenPercent = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.totemManaRegenPercent)).ifPresent(tag -> nbt.m_128365_("totemManaRegenPercent", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.totemManaRegenPercent = Adapters.FLOAT.readNbt(nbt.m_128423_("totemManaRegenPercent")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.totemManaRegenPercent)).ifPresent(element -> json.add("totemManaRegenPercent", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.totemManaRegenPercent = Adapters.FLOAT.readJson(json.get("totemManaRegenPercent")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public static class TotemManaRegenMobEffectInstance
    extends MobEffectInstance {
        private final float manaRegen;

        public TotemManaRegenMobEffectInstance(MobEffect pEffect, int pDuration, int pAmplifier, boolean pAmbient, boolean pVisible, boolean pShowIcon, float manaRegen) {
            super(pEffect, pDuration, pAmplifier, pAmbient, pVisible, pShowIcon);
            this.manaRegen = manaRegen;
        }
    }

    public static class TotemManaRegenEffect
    extends MobEffect {
        private static final UUID UUID = java.util.UUID.fromString("9fac344f-fb1a-4a30-bb79-a2895e09a4a0");

        public TotemManaRegenEffect(int color, ResourceLocation id) {
            super(MobEffectCategory.BENEFICIAL, color);
            this.setRegistryName(id);
        }

        public static void addTo(LivingEntity livingEntity, float amount) {
            livingEntity.m_7292_(TotemManaRegenEffect.instance(amount));
        }

        private static MobEffectInstance instance(float amount) {
            return new TotemManaRegenMobEffectInstance(ModEffects.TOTEM_MANA_REGEN, 5, 0, false, false, true, amount);
        }

        @ParametersAreNonnullByDefault
        public void m_6385_(LivingEntity livingEntity, AttributeMap attributeMap, int amplifier) {
            if (!(livingEntity instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)livingEntity;
            AttributeInstance attributeInstance = player.m_21051_(ModAttributes.MANA_REGEN);
            if (attributeInstance == null) {
                return;
            }
            MobEffectInstance mobEffectInstance = player.m_21124_((MobEffect)this);
            if (!(mobEffectInstance instanceof TotemManaRegenMobEffectInstance)) {
                attributeInstance.m_22120_(UUID);
                return;
            }
            TotemManaRegenMobEffectInstance effectInstance = (TotemManaRegenMobEffectInstance)mobEffectInstance;
            AttributeModifier modifier = new AttributeModifier(UUID, "totem_mana_regen", (double)effectInstance.manaRegen, AttributeModifier.Operation.MULTIPLY_BASE);
            attributeInstance.m_22118_(modifier);
        }

        @ParametersAreNonnullByDefault
        public void m_6386_(LivingEntity livingEntity, AttributeMap attributeMap, int amplifier) {
            if (!(livingEntity instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)livingEntity;
            AttributeInstance attributeInstance = player.m_21051_(ModAttributes.MANA_REGEN);
            if (attributeInstance == null) {
                return;
            }
            attributeInstance.m_22120_(UUID);
        }
    }
}

