/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.skill.ability.effect.VeinMinerAbility;
import iskallia.vault.util.OverlevelEnchantHelper;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class VeinMinerFortuneAbility
extends VeinMinerAbility {
    private int additionalFortuneLevel;

    public VeinMinerFortuneAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, int blockLimit, int additionalFortuneLevel) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, blockLimit);
        this.additionalFortuneLevel = additionalFortuneLevel;
    }

    public VeinMinerFortuneAbility() {
    }

    public int getAdditionalFortuneLevel() {
        return this.additionalFortuneLevel;
    }

    @Override
    protected ItemStack getVeinMiningItemProxy(Player player) {
        ItemStack stack = super.getVeinMiningItemProxy(player).m_41777_();
        return OverlevelEnchantHelper.increaseFortuneBy(stack, this.getAdditionalFortuneLevel());
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.additionalFortuneLevel, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.additionalFortuneLevel = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.INT.writeNbt(this.additionalFortuneLevel).ifPresent(tag -> nbt.m_128365_("additionalFortuneLevel", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.additionalFortuneLevel = Adapters.INT.readNbt(nbt.m_128423_("additionalFortuneLevel")).orElse(0);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.INT.writeJson(this.additionalFortuneLevel).ifPresent(element -> json.add("additionalFortuneLevel", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.additionalFortuneLevel = Adapters.INT.readJson(json.get("additionalFortuneLevel")).orElse(0);
    }
}

