/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect.spi;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.skill.ability.effect.spi.core.InstantManaAbility;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.util.AABBHelper;
import iskallia.vault.util.calc.AreaOfEffectHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBonkAbility
extends InstantManaAbility {
    private float radius;
    private int maxStacksTotal;
    private int maxStacksUsedPerHit;
    private int stackDuration;

    public AbstractBonkAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, float radius, int maxStacksTotal, int maxStacksUsedPerHit, int stackDuration) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost);
        this.radius = radius;
        this.maxStacksTotal = maxStacksTotal;
        this.maxStacksUsedPerHit = maxStacksUsedPerHit;
        this.stackDuration = stackDuration;
    }

    protected AbstractBonkAbility() {
    }

    public int getMaxStacksUsedPerHit() {
        return this.maxStacksUsedPerHit;
    }

    public int getStackDuration() {
        return this.stackDuration;
    }

    public int getMaxStacksTotal() {
        return this.maxStacksTotal;
    }

    public float getUnmodifiedRadius() {
        return this.radius;
    }

    public float getRadius(Entity attacker) {
        float realRadius = this.getUnmodifiedRadius();
        if (attacker instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)attacker;
            realRadius = AreaOfEffectHelper.adjustAreaOfEffect(livingEntity, realRadius);
        }
        return realRadius;
    }

    @Override
    public String getAbilityGroupName() {
        return "Battle_Cry";
    }

    @Override
    protected void doParticles(SkillContext context) {
    }

    @NotNull
    protected List<LivingEntity> getTargetEntities(Level world, LivingEntity attacker, Vec3 pos) {
        float radius = this.getRadius((Entity)attacker);
        return world.m_45971_(LivingEntity.class, TargetingConditions.m_148352_().m_26883_((double)radius).m_26888_(entity -> !(entity instanceof Player)), attacker, AABBHelper.create(pos, radius));
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.radius), buffer);
        Adapters.INT.writeBits(this.maxStacksTotal, buffer);
        Adapters.INT.writeBits(this.maxStacksUsedPerHit, buffer);
        Adapters.INT.writeBits(this.stackDuration, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.radius = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.maxStacksTotal = (Integer)Adapters.INT.readBits(buffer).orElseThrow();
        this.maxStacksUsedPerHit = (Integer)Adapters.INT.readBits(buffer).orElseThrow();
        this.stackDuration = (Integer)Adapters.INT.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.radius)).ifPresent(tag -> nbt.m_128365_("radius", tag));
            Adapters.INT.writeNbt(this.maxStacksTotal).ifPresent(tag -> nbt.m_128365_("maxStacksTotal", tag));
            Adapters.INT.writeNbt(this.maxStacksUsedPerHit).ifPresent(tag -> nbt.m_128365_("maxStacksUsedPerHit", tag));
            Adapters.INT.writeNbt(this.stackDuration).ifPresent(tag -> nbt.m_128365_("stackDuration", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.radius = Adapters.FLOAT.readNbt(nbt.m_128423_("radius")).orElse(Float.valueOf(0.0f)).floatValue();
        this.maxStacksTotal = Adapters.INT.readNbt(nbt.m_128423_("maxStacksTotal")).orElse(0);
        this.maxStacksUsedPerHit = Adapters.INT.readNbt(nbt.m_128423_("maxStacksUsedPerHit")).orElse(0);
        this.stackDuration = Adapters.INT.readNbt(nbt.m_128423_("stackDuration")).orElse(0);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.radius)).ifPresent(element -> json.add("radius", element));
            Adapters.INT.writeJson(this.maxStacksTotal).ifPresent(element -> json.add("maxStacksTotal", element));
            Adapters.INT.writeJson(this.maxStacksUsedPerHit).ifPresent(element -> json.add("maxStacksUsedPerHit", element));
            Adapters.INT.writeJson(this.stackDuration).ifPresent(element -> json.add("stackDuration", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.radius = Adapters.FLOAT.readJson(json.get("radius")).orElse(Float.valueOf(0.0f)).floatValue();
        this.maxStacksTotal = Adapters.INT.readJson(json.get("maxStacksTotal")).orElse(0);
        this.maxStacksUsedPerHit = Adapters.INT.readJson(json.get("maxStacksUsedPerHit")).orElse(0);
        this.stackDuration = Adapters.INT.readJson(json.get("stackDuration")).orElse(0);
    }

    public static class BattleCryEffect
    extends MobEffect {
        public BattleCryEffect(MobEffectCategory category, int color, ResourceLocation id) {
            super(category, color);
            this.setRegistryName(id);
        }
    }
}

