/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect.spi;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.entity.entity.EternalEntity;
import iskallia.vault.event.ActiveFlags;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModEntities;
import iskallia.vault.init.ModSounds;
import iskallia.vault.mana.Mana;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.ability.effect.spi.core.ToggleAbilityEffect;
import iskallia.vault.skill.ability.effect.spi.core.ToggleManaAbility;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.util.EntityHelper;
import iskallia.vault.util.calc.AbilityPowerHelper;
import iskallia.vault.util.calc.AreaOfEffectHelper;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class AbstractSmiteAbility
extends ToggleManaAbility {
    private float additionalManaPerBolt;
    private float radius;
    private int intervalTicks;
    private int color;
    private float percentAbilityPowerDealt;
    private static final String TAG_ABILITY_DATA = "the_vault:ability/_Smite";
    private static final String TAG_REMAINING_INTERVAL_TICKS = "remainingIntervalTicks";
    public static final Predicate<Entity> ENTITY_PREDICATE = entity -> {
        LivingEntity livingEntity;
        return !(entity instanceof Player) && entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_6084_() && (VaultUtils.isVaultLevel(entity.f_19853_) || entity.m_6095_().m_20674_() == MobCategory.MONSTER);
    };

    public AbstractSmiteAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCostPerSecond, float radius, int intervalTicks, float percentAbilityPowerDealt, int color, float additionalManaPerBolt) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCostPerSecond);
        this.radius = radius;
        this.intervalTicks = intervalTicks;
        this.percentAbilityPowerDealt = percentAbilityPowerDealt;
        this.color = color;
        this.additionalManaPerBolt = additionalManaPerBolt;
    }

    public float getAdditionalManaPerBolt() {
        return this.additionalManaPerBolt;
    }

    protected AbstractSmiteAbility() {
    }

    public ActiveFlags getFlag() {
        return ActiveFlags.IS_SMITE_ATTACKING;
    }

    public float getUnmodifiedRadius() {
        return this.radius;
    }

    public float getRadius(Entity attacker) {
        float realRadius = this.getUnmodifiedRadius();
        if (attacker instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)attacker;
            realRadius = AreaOfEffectHelper.adjustAreaOfEffect(livingEntity, realRadius);
        }
        return realRadius;
    }

    public int getIntervalTicks() {
        return this.intervalTicks;
    }

    public float getAbilityPowerPercent() {
        return this.percentAbilityPowerDealt;
    }

    public int getColor() {
        return this.color;
    }

    public ToggleAbilityEffect getEffect() {
        return ModEffects.SMITE;
    }

    @Override
    public String getAbilityGroupName() {
        return "Smite";
    }

    @Override
    protected Ability.ActionResult doToggle(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            if (this.isActive()) {
                this.getEffect().addTo((LivingEntity)player, 0);
                AbstractSmiteAbility.clearRemainingInterval(player);
                return Ability.ActionResult.successCooldownDeferred();
            }
            player.m_21195_((MobEffect)this.getEffect());
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    @Override
    protected void doToggleSound(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> {
            if (this.isActive()) {
                player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.SMITE, SoundSource.PLAYERS, 0.5f, 1.0f);
                player.m_6330_(ModSounds.SMITE, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
        });
    }

    @Override
    public Ability.TickResult doInactiveTick(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            if (player.m_21023_((MobEffect)this.getEffect())) {
                player.m_21195_((MobEffect)this.getEffect());
            }
            return Ability.TickResult.PASS;
        }).orElse(Ability.TickResult.PASS);
    }

    @Override
    public void onRemove(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(entity -> entity.m_21195_((MobEffect)this.getEffect()));
    }

    @Override
    protected void doManaDepleted(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(entity -> entity.m_21195_((MobEffect)this.getEffect()));
    }

    private static CompoundTag getAbilityData(ServerPlayer serverPlayer) {
        CompoundTag persistentData = serverPlayer.getPersistentData();
        CompoundTag abilityData = persistentData.m_128469_(TAG_ABILITY_DATA);
        persistentData.m_128365_(TAG_ABILITY_DATA, (Tag)abilityData);
        return abilityData;
    }

    private static boolean decrementRemainingInterval(ServerPlayer serverPlayer, int intervalTicks) {
        boolean result = false;
        CompoundTag abilityData = AbstractSmiteAbility.getAbilityData(serverPlayer);
        int value = abilityData.m_128451_(TAG_REMAINING_INTERVAL_TICKS) - 1;
        if (value <= 0) {
            result = true;
            value = intervalTicks;
        }
        abilityData.m_128405_(TAG_REMAINING_INTERVAL_TICKS, value);
        return result;
    }

    private static void setPercentRemainingInterval(ServerPlayer serverPlayer, int intervalTicks) {
        CompoundTag abilityData = AbstractSmiteAbility.getAbilityData(serverPlayer);
        abilityData.m_128405_(TAG_REMAINING_INTERVAL_TICKS, Math.min(intervalTicks, 10));
    }

    private static void clearRemainingInterval(ServerPlayer serverPlayer) {
        AbstractSmiteAbility.getAbilityData(serverPlayer).m_128405_(TAG_REMAINING_INTERVAL_TICKS, 0);
    }

    @Override
    public Ability.TickResult doActiveTick(SkillContext context) {
        Ability.TickResult result = super.doActiveTick(context);
        if (result == Ability.TickResult.PASS) {
            return context.getSource().as(ServerPlayer.class).map(player -> {
                if (!player.m_21023_((MobEffect)this.getEffect())) {
                    return Ability.TickResult.PASS;
                }
                if (AbstractSmiteAbility.decrementRemainingInterval(player, this.getIntervalTicks()) && this.doDamage((ServerPlayer)player, this.getRadius((Entity)player), this.getAbilityPowerPercent())) {
                    this.setActive(false);
                    this.doManaDepleted(context);
                    return Ability.TickResult.COOLDOWN;
                }
                return Ability.TickResult.PASS;
            }).orElse(Ability.TickResult.PASS);
        }
        return result;
    }

    private boolean doDamage(ServerPlayer player, float radius, float percentAbilityPowerDealt) {
        ArrayList<LivingEntity> result = new ArrayList<LivingEntity>();
        EntityHelper.getEntitiesInRange((LevelAccessor)player.f_19853_, player.m_20182_(), radius, ENTITY_PREDICATE, result);
        boolean applyCooldown = false;
        result.removeIf(entity -> entity instanceof EternalEntity);
        if (result.isEmpty()) {
            AbstractSmiteAbility.setPercentRemainingInterval(player, this.getIntervalTicks());
            return false;
        }
        LivingEntity livingEntity = result.get(player.f_19853_.f_46441_.nextInt(result.size()));
        SmiteBolt smiteBolt = (SmiteBolt)ModEntities.SMITE_ABILITY_BOLT.m_20615_(player.f_19853_);
        if (smiteBolt != null) {
            smiteBolt.setColor(this.getColor());
            smiteBolt.m_20219_(livingEntity.m_20182_());
            player.f_19853_.m_7967_((Entity)smiteBolt);
        }
        if (!player.m_7500_() && Mana.decrease((Player)player, this.getAdditionalManaPerBolt()) <= 0.0f) {
            player.m_21195_((MobEffect)this.getEffect());
            applyCooldown = true;
        }
        ActiveFlags.IS_AP_ATTACKING.runIfNotSet(() -> this.getFlag().runIfNotSet(() -> {
            double damage = AbilityPowerHelper.getAbilityPower((Player)player) * percentAbilityPowerDealt;
            livingEntity.m_6469_(DamageSource.m_19344_((Player)player), (float)damage);
        }));
        if (this.getFlag() == ActiveFlags.IS_SMITE_BASE_ATTACKING) {
            player.f_19853_.m_6263_(null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), ModSounds.SMITE_BOLT, SoundSource.PLAYERS, 1.0f, 1.0f + Mth.m_144924_((Random)livingEntity.m_21187_(), (float)-0.2f, (float)0.2f));
        } else {
            player.f_19853_.m_6263_(null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), ModSounds.SMITE_BOLT, SoundSource.PLAYERS, 0.7f, 1.5f + Mth.m_144924_((Random)livingEntity.m_21187_(), (float)-0.2f, (float)0.2f));
        }
        return applyCooldown;
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.radius), buffer);
        Adapters.INT_SEGMENTED_7.writeBits(this.intervalTicks, buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.percentAbilityPowerDealt), buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.additionalManaPerBolt), buffer);
        Adapters.INT.writeBits(this.color, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.radius = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.intervalTicks = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
        this.percentAbilityPowerDealt = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.additionalManaPerBolt = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.color = (Integer)Adapters.INT.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.radius)).ifPresent(tag -> nbt.m_128365_("radius", tag));
            Adapters.INT.writeNbt(this.intervalTicks).ifPresent(tag -> nbt.m_128365_("intervalTicks", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.percentAbilityPowerDealt)).ifPresent(tag -> nbt.m_128365_("percentAbilityPowerDealt", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.additionalManaPerBolt)).ifPresent(tag -> nbt.m_128365_("additionalManaPerBolt", tag));
            Adapters.INT.writeNbt(this.color).ifPresent(tag -> nbt.m_128365_("color", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.radius = Adapters.FLOAT.readNbt(nbt.m_128423_("radius")).orElse(Float.valueOf(0.0f)).floatValue();
        this.intervalTicks = Adapters.INT.readNbt(nbt.m_128423_("intervalTicks")).orElse(0);
        this.percentAbilityPowerDealt = Adapters.FLOAT.readNbt(nbt.m_128423_("percentAbilityPowerDealt")).orElse(Float.valueOf(0.0f)).floatValue();
        this.additionalManaPerBolt = Adapters.FLOAT.readNbt(nbt.m_128423_("additionalManaPerBolt")).orElse(Float.valueOf(0.0f)).floatValue();
        this.intervalTicks = Adapters.INT.readNbt(nbt.m_128423_("color")).orElse(0);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.radius)).ifPresent(element -> json.add("radius", element));
            Adapters.INT.writeJson(this.intervalTicks).ifPresent(element -> json.add("intervalTicks", element));
            Adapters.FLOAT.writeJson(Float.valueOf(this.percentAbilityPowerDealt)).ifPresent(element -> json.add("percentAbilityPowerDealt", element));
            Adapters.FLOAT.writeJson(Float.valueOf(this.additionalManaPerBolt)).ifPresent(element -> json.add("additionalManaPerBolt", element));
            Adapters.INT.writeJson(this.color).ifPresent(element -> json.add("color", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.radius = Adapters.FLOAT.readJson(json.get("radius")).orElse(Float.valueOf(0.0f)).floatValue();
        this.intervalTicks = Adapters.INT.readJson(json.get("intervalTicks")).orElse(0);
        this.percentAbilityPowerDealt = Adapters.FLOAT.readJson(json.get("percentAbilityPowerDealt")).orElse(Float.valueOf(0.0f)).floatValue();
        this.additionalManaPerBolt = Adapters.FLOAT.readJson(json.get("additionalManaPerBolt")).orElse(Float.valueOf(0.0f)).floatValue();
        this.color = Adapters.INT.readJson(json.get("color")).orElse(0);
    }

    public static class SmiteBolt
    extends Entity {
        private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(SmiteBolt.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        private final boolean flashSky;
        private int life;
        public long seed;
        private int flashes;

        public SmiteBolt(EntityType<? extends SmiteBolt> entityType, Level level, boolean flashSky, int color) {
            super(entityType, level);
            this.flashSky = flashSky;
            this.f_19811_ = true;
            this.life = 2;
            this.seed = this.f_19796_.nextLong();
            this.flashes = this.f_19796_.nextInt(3) + 1;
            this.setColor(color);
        }

        @Nonnull
        public SoundSource m_5720_() {
            return SoundSource.PLAYERS;
        }

        protected void m_8097_() {
            this.f_19804_.m_135372_(COLOR, (Object)0);
        }

        @Nonnull
        public Packet<?> m_5654_() {
            return new ClientboundAddEntityPacket((Entity)this);
        }

        public void setColor(int color) {
            this.f_19804_.m_135381_(COLOR, (Object)color);
        }

        public void m_8119_() {
            super.m_8119_();
            --this.life;
            if (this.life < 0) {
                if (this.flashes == 0) {
                    this.m_146870_();
                } else if (this.life < -this.f_19796_.nextInt(10)) {
                    --this.flashes;
                    this.life = 1;
                    this.seed = this.f_19796_.nextLong();
                }
            }
            if (this.life >= 0 && this.flashSky && !(this.f_19853_ instanceof ServerLevel)) {
                this.f_19853_.m_6580_(2);
            }
        }

        public boolean m_6783_(double distance) {
            double dSqr = 64.0 * SmiteBolt.m_20150_();
            return distance < dSqr * dSqr;
        }

        protected void m_7378_(@Nonnull CompoundTag compound) {
        }

        protected void m_7380_(@Nonnull CompoundTag compound) {
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class SmiteBoltRenderer
    extends EntityRenderer<SmiteBolt> {
        public SmiteBoltRenderer(EntityRendererProvider.Context context) {
            super(context);
        }

        @Nonnull
        public ResourceLocation getTextureLocation(@Nonnull SmiteBolt entity) {
            return TextureAtlas.f_118259_;
        }

        @ParametersAreNonnullByDefault
        public void render(SmiteBolt entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferSource, int packedLight) {
            float[] afloat = new float[8];
            float[] afloat1 = new float[8];
            float f = 0.0f;
            float f1 = 0.0f;
            Random random = new Random(entity.seed);
            for (int i = 7; i >= 0; --i) {
                afloat[i] = f;
                afloat1[i] = f1;
                f += (float)(random.nextInt(11) - 5);
                f1 += (float)(random.nextInt(11) - 5);
            }
            VertexConsumer vertexconsumer = bufferSource.m_6299_(RenderType.m_110502_());
            matrixStack.m_85836_();
            matrixStack.m_85841_(0.1f, 0.1f, 0.1f);
            Matrix4f matrix4f = matrixStack.m_85850_().m_85861_();
            for (int j = 0; j < 4; ++j) {
                Random random1 = new Random(entity.seed);
                for (int k = 0; k < 3; ++k) {
                    int l = 7;
                    int i1 = 0;
                    if (k > 0) {
                        l = 7 - k;
                    }
                    if (k > 0) {
                        i1 = l - 2;
                    }
                    float f2 = afloat[l] - f;
                    float f3 = afloat1[l] - f1;
                    for (int j1 = l; j1 >= i1; --j1) {
                        float f4 = f2;
                        float f5 = f3;
                        if (k == 0) {
                            f2 += (float)(random1.nextInt(11) - 5);
                            f3 += (float)(random1.nextInt(11) - 5);
                        } else {
                            f2 += (float)(random1.nextInt(31) - 15);
                            f3 += (float)(random1.nextInt(31) - 15);
                        }
                        float f10 = 0.1f + (float)j * 0.2f;
                        if (k == 0) {
                            f10 *= (float)j1 * 0.1f + 1.0f;
                        }
                        float f11 = 0.1f + (float)j * 0.2f;
                        if (k == 0) {
                            f11 *= ((float)j1 - 1.0f) * 0.1f + 1.0f;
                        }
                        int color = (Integer)entity.m_20088_().m_135370_(SmiteBolt.COLOR);
                        float r = (float)(color >>> 16 & 0xFF) / 255.0f;
                        float g = (float)(color >>> 8 & 0xFF) / 255.0f;
                        float b = (float)(color & 0xFF) / 255.0f;
                        SmiteBoltRenderer.quad(matrix4f, vertexconsumer, f2, f3, j1, f4, f5, r, g, b, f10, f11, false, false, true, false);
                        SmiteBoltRenderer.quad(matrix4f, vertexconsumer, f2, f3, j1, f4, f5, r, g, b, f10, f11, true, false, true, true);
                        SmiteBoltRenderer.quad(matrix4f, vertexconsumer, f2, f3, j1, f4, f5, r, g, b, f10, f11, true, true, false, true);
                        SmiteBoltRenderer.quad(matrix4f, vertexconsumer, f2, f3, j1, f4, f5, r, g, b, f10, f11, false, true, false, false);
                    }
                }
            }
            matrixStack.m_85849_();
        }

        private static void quad(Matrix4f matrix, VertexConsumer vertexConsumer, float x, float z, int y, float p_115278_, float p_115279_, float r, float g, float b, float p_115283_, float p_115284_, boolean p_115285_, boolean p_115286_, boolean p_115287_, boolean p_115288_) {
            vertexConsumer.m_85982_(matrix, x + (p_115285_ ? p_115284_ : -p_115284_), (float)(y * 16), z + (p_115286_ ? p_115284_ : -p_115284_)).m_85950_(r, g, b, 0.3f).m_5752_();
            vertexConsumer.m_85982_(matrix, p_115278_ + (p_115285_ ? p_115283_ : -p_115283_), (float)((y + 1) * 16), p_115279_ + (p_115286_ ? p_115283_ : -p_115283_)).m_85950_(r, g, b, 0.3f).m_5752_();
            vertexConsumer.m_85982_(matrix, p_115278_ + (p_115287_ ? p_115283_ : -p_115283_), (float)((y + 1) * 16), p_115279_ + (p_115288_ ? p_115283_ : -p_115283_)).m_85950_(r, g, b, 0.3f).m_5752_();
            vertexConsumer.m_85982_(matrix, x + (p_115287_ ? p_115284_ : -p_115284_), (float)(y * 16), z + (p_115288_ ? p_115284_ : -p_115284_)).m_85950_(r, g, b, 0.3f).m_5752_();
        }
    }

    public static class SmiteEffect
    extends ToggleAbilityEffect {
        public SmiteEffect(int color, ResourceLocation resourceLocation) {
            super(AbstractSmiteAbility.class, color, resourceLocation);
        }
    }
}

