/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect.spi;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.event.ActiveFlags;
import iskallia.vault.gear.attribute.ability.special.VeinMinerAdditionalBlocksModification;
import iskallia.vault.gear.attribute.ability.special.base.ConfiguredModification;
import iskallia.vault.gear.attribute.ability.special.base.SpecialAbilityModification;
import iskallia.vault.gear.attribute.ability.special.base.template.IntValueConfig;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.item.tool.ToolItem;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.ability.effect.spi.core.HoldAbility;
import iskallia.vault.skill.tree.AbilityTree;
import iskallia.vault.util.BlockBreakHandler;
import iskallia.vault.util.calc.AreaOfEffectHelper;
import iskallia.vault.world.data.PlayerAbilitiesData;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="the_vault", bus=Mod.EventBusSubscriber.Bus.FORGE)
public abstract class AbstractVeinMinerAbility
extends HoldAbility {
    private final BlockBreakHandler blockBreakHandler = new BlockBreakHandler(){

        @Override
        protected int getBlockLimit(Player player) {
            return AbstractVeinMinerAbility.this.getBlockLimit(player);
        }

        @Override
        protected ItemStack getMiningItemProxy(Player player) {
            return AbstractVeinMinerAbility.this.getVeinMiningItemProxy(player);
        }

        @Override
        protected boolean shouldVoid(ServerLevel level, ServerPlayer player, BlockState blockState) {
            return AbstractVeinMinerAbility.this.shouldVoid(level, player, blockState);
        }
    };
    private int blockLimit;

    protected AbstractVeinMinerAbility() {
    }

    public AbstractVeinMinerAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, int blockLimit) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks);
        this.blockLimit = blockLimit;
    }

    public int getUnmodifiedBlockLimit() {
        return this.blockLimit;
    }

    public int getBlockLimit(Player player) {
        int blocks = this.getUnmodifiedBlockLimit();
        for (ConfiguredModification mod : SpecialAbilityModification.getModifications((LivingEntity)player, VeinMinerAdditionalBlocksModification.class)) {
            blocks = mod.modification().adjustBlockCount((IntValueConfig)mod.config(), blocks);
        }
        blocks = Math.round(AreaOfEffectHelper.adjustAreaOfEffect((LivingEntity)player, blocks));
        return blocks;
    }

    @Override
    public String getAbilityGroupName() {
        return "Vein Miner";
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBlockMined(BlockEvent.BreakEvent event) {
        VaultGearData gearData;
        ServerPlayer player;
        Player player2;
        block6: {
            block5: {
                if (event.getWorld().m_5776_() || event.getPlayer() instanceof FakePlayer || !((player2 = event.getPlayer()) instanceof ServerPlayer)) break block5;
                player = (ServerPlayer)player2;
                player2 = event.getWorld();
                if (player2 instanceof ServerLevel) break block6;
            }
            return;
        }
        ServerLevel level = (ServerLevel)player2;
        if (event.getPlayer().m_21205_().m_41720_() instanceof ToolItem && (gearData = VaultGearData.read(event.getPlayer().m_21205_())).has(ModGearAttributes.HAMMERING)) {
            return;
        }
        AbilityTree abilities = PlayerAbilitiesData.get(level).getAbilities((Player)player);
        for (AbstractVeinMinerAbility ability : abilities.getAll(AbstractVeinMinerAbility.class, Ability::isActive)) {
            if (ability.isItemDenied(player.m_21120_(InteractionHand.MAIN_HAND))) continue;
            abilities.getSelectedAbility().ifPresent(selected -> {
                if (selected.getClass() == ability.getClass()) {
                    ActiveFlags.IS_AOE_MINING.runIfNotSet(() -> {
                        BlockState blockState;
                        BlockPos pos = event.getPos();
                        if (ability.blockBreakHandler.areaDig(level, player, pos, (blockState = level.m_8055_(pos)).m_60734_())) {
                            event.setCanceled(true);
                        }
                    });
                }
            });
        }
    }

    private boolean isItemDenied(ItemStack itemStack) {
        return ModConfigs.ABILITIES_VEIN_MINER_DENY_CONFIG.isItemDenied(itemStack);
    }

    protected abstract ItemStack getVeinMiningItemProxy(Player var1);

    public abstract boolean shouldVoid(ServerLevel var1, ServerPlayer var2, BlockState var3);

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.INT_SEGMENTED_7.writeBits(this.blockLimit, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.blockLimit = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.INT.writeNbt(this.blockLimit).ifPresent(tag -> nbt.m_128365_("blockLimit", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.blockLimit = Adapters.INT.readNbt(nbt.m_128423_("blockLimit")).orElse(0);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.INT.writeJson(this.blockLimit).ifPresent(element -> json.add("blockLimit", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.blockLimit = Adapters.INT.readJson(json.get("blockLimit")).orElse(0);
    }
}

