/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect.spi;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.array.ArrayAdapter;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.world.data.tile.PartialTile;
import iskallia.vault.core.world.data.tile.TilePredicate;
import iskallia.vault.gear.attribute.ability.special.HunterRangeModification;
import iskallia.vault.gear.attribute.ability.special.base.ConfiguredModification;
import iskallia.vault.gear.attribute.ability.special.base.SpecialAbilityModification;
import iskallia.vault.gear.attribute.ability.special.base.template.FloatValueConfig;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModSounds;
import iskallia.vault.network.message.ClientboundHunterParticlesMessage;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.ability.effect.spi.core.InstantManaAbility;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.util.ServerScheduler;
import iskallia.vault.util.calc.AreaOfEffectHelper;
import iskallia.vault.world.data.ServerVaults;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkDirection;

public class HunterAbility
extends InstantManaAbility {
    private double searchRadius;
    private int color;
    private int durationTicks;
    private List<TilePredicate> filters;
    private static ArrayAdapter<TilePredicate> KEYS = Adapters.ofArray(TilePredicate[]::new, Adapters.TILE_PREDICATE);

    public HunterAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, double searchRadius, int color, int durationTicks, List<TilePredicate> filters) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost);
        this.searchRadius = searchRadius;
        this.color = color;
        this.durationTicks = durationTicks;
        this.filters = filters;
    }

    public HunterAbility() {
    }

    public double getUnmodifiedSearchRadius() {
        return this.searchRadius;
    }

    public double getRadius(Entity attacker) {
        double realRadius = this.getUnmodifiedSearchRadius();
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            for (ConfiguredModification mod : SpecialAbilityModification.getModifications((LivingEntity)player, HunterRangeModification.class)) {
                realRadius = mod.modification().adjustRange((FloatValueConfig)mod.config(), realRadius);
            }
        }
        if (attacker instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)attacker;
            realRadius = AreaOfEffectHelper.adjustAreaOfEffect(livingEntity, (float)realRadius);
        }
        return realRadius;
    }

    public int getColor() {
        return this.color;
    }

    public int getDurationTicks() {
        return this.durationTicks;
    }

    public List<TilePredicate> getFilters() {
        return this.filters;
    }

    public boolean shouldHighlightTile(PartialTile tile) {
        return this.filters.stream().anyMatch(filter -> filter.test(tile));
    }

    @Override
    public String getAbilityGroupName() {
        return "Hunter";
    }

    @Override
    protected boolean canDoAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> super.canDoAction(context) && ServerVaults.get(player.f_19853_).isPresent()).orElse(false);
    }

    @Override
    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            Level world = player.m_20193_();
            if (!(world instanceof ServerLevel)) {
                return Ability.ActionResult.fail();
            }
            ServerLevel serverWorld = (ServerLevel)world;
            for (int delay = 0; delay < this.getDurationTicks() / 5; ++delay) {
                ServerScheduler.INSTANCE.schedule(delay * 5, () -> HunterAbility.selectPositions(serverWorld, player, this.getRadius((Entity)player), new Color(this.getColor(), false), this::shouldHighlightTile).forEach(highlightPosition -> {
                    Color color = highlightPosition.color;
                    for (int i = 0; i < 8; ++i) {
                        Vec3 v = MiscUtils.getRandomOffset(highlightPosition.blockPos, serverWorld.m_5822_());
                        ModNetwork.CHANNEL.sendTo((Object)new ClientboundHunterParticlesMessage(v.f_82479_, v.f_82480_, v.f_82481_, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f), player.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
                    }
                }));
            }
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
    }

    @Override
    protected void doParticles(SkillContext context) {
    }

    @Override
    protected void doSound(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> player.f_19853_.m_6263_(null, player.m_20182_().f_82479_, player.m_20182_().f_82480_, player.m_20182_().f_82481_, ModSounds.HUNTER_SFX, SoundSource.PLAYERS, 1.0f, 1.0f));
    }

    public static List<HighlightPosition> selectPositions(ServerLevel world, ServerPlayer player, double radius, Color color, Predicate<PartialTile> shouldHighlight) {
        ArrayList<HighlightPosition> result = new ArrayList<HighlightPosition>();
        HunterAbility.forEachTile((Level)world, (Player)player, radius, tile -> {
            if (shouldHighlight.test((PartialTile)tile)) {
                result.add(new HighlightPosition(tile.getPos(), color));
            }
        });
        return result;
    }

    private static void forEachTile(Level world, Player player, double radius, Consumer<PartialTile> consumer) {
        BlockPos playerOffset = player.m_142538_();
        double radiusSq = radius * radius;
        int iRadius = Mth.m_14165_((double)radius);
        Vec3i radVec = new Vec3i(iRadius, iRadius, iRadius);
        ChunkPos posMin = new ChunkPos(player.m_142538_().m_141950_(radVec));
        ChunkPos posMax = new ChunkPos(player.m_142538_().m_141952_(radVec));
        for (int xx = posMin.f_45578_; xx <= posMax.f_45578_; ++xx) {
            for (int zz = posMin.f_45579_; zz <= posMax.f_45579_; ++zz) {
                LevelChunk ch = world.m_7726_().m_7131_(xx, zz);
                if (ch == null) continue;
                ch.m_62954_().forEach((pos, tile) -> {
                    if (tile != null && pos.m_123331_((Vec3i)playerOffset) <= radiusSq) {
                        consumer.accept(PartialTile.at((BlockGetter)world, pos));
                    }
                });
            }
        }
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.DOUBLE.writeBits(this.searchRadius, buffer);
        Adapters.INT.writeBits(this.color, buffer);
        Adapters.INT_SEGMENTED_7.writeBits(this.durationTicks, buffer);
        KEYS.writeBits((TilePredicate)((TilePredicate[])this.filters.toArray(TilePredicate[]::new)), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.searchRadius = (Double)Adapters.DOUBLE.readBits(buffer).orElseThrow();
        this.color = (Integer)Adapters.INT.readBits(buffer).orElseThrow();
        this.durationTicks = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
        this.filters = Arrays.stream((TilePredicate[])KEYS.readBits(buffer).orElseThrow()).toList();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.DOUBLE.writeNbt(this.searchRadius).ifPresent(tag -> nbt.m_128365_("searchRadius", tag));
            Adapters.INT.writeNbt(this.color).ifPresent(tag -> nbt.m_128365_("color", tag));
            Adapters.INT.writeNbt(this.durationTicks).ifPresent(tag -> nbt.m_128365_("durationTicks", tag));
            KEYS.writeNbt((TilePredicate)((TilePredicate[])this.filters.toArray(TilePredicate[]::new))).ifPresent(tag -> nbt.m_128365_("filters", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.searchRadius = Adapters.DOUBLE.readNbt(nbt.m_128423_("searchRadius")).orElse(0.0);
        this.color = Adapters.INT.readNbt(nbt.m_128423_("color")).orElse(0);
        this.durationTicks = Adapters.INT.readNbt(nbt.m_128423_("durationTicks")).orElse(0);
        this.filters = Arrays.stream(KEYS.readNbt(nbt.m_128423_("filters")).orElse(new TilePredicate[0])).toList();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.DOUBLE.writeJson(this.searchRadius).ifPresent(element -> json.add("searchRadius", element));
            Adapters.INT.writeJson(this.color).ifPresent(element -> json.add("color", element));
            Adapters.INT.writeJson(this.durationTicks).ifPresent(element -> json.add("durationTicks", element));
            KEYS.writeJson((TilePredicate)((TilePredicate[])this.filters.toArray(TilePredicate[]::new))).ifPresent(element -> json.add("filters", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.searchRadius = Adapters.DOUBLE.readJson(json.get("searchRadius")).orElse(0.0);
        this.color = Adapters.INT.readJson(json.get("color")).orElse(0);
        this.durationTicks = Adapters.INT.readJson(json.get("durationTicks")).orElse(0);
        this.filters = Arrays.stream(KEYS.readJson(json.get("filters")).orElse(new TilePredicate[0])).toList();
    }

    public record HighlightPosition(BlockPos blockPos, Color color) {
    }
}

