/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect.spi.core;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.init.ModSounds;
import iskallia.vault.skill.ability.effect.spi.core.Cooldown;
import iskallia.vault.skill.ability.effect.spi.core.CooldownSkill;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.base.TickingSkill;
import iskallia.vault.util.calc.CooldownHelper;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;

public abstract class Ability
extends LearnableSkill
implements TickingSkill,
CooldownSkill {
    private int cooldownTicks;
    private Cooldown cooldown;
    private boolean active;

    public Ability(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks) {
        super(unlockLevel, learnPointCost, regretPointCost);
        this.cooldownTicks = cooldownTicks;
        this.cooldown = null;
        this.active = false;
    }

    protected Ability() {
    }

    public boolean isActive() {
        return this.active;
    }

    public int getCooldownTicks() {
        return this.cooldownTicks;
    }

    @Override
    public Optional<Cooldown> getCooldown() {
        return Optional.ofNullable(this.cooldown);
    }

    protected void setCooldown(int cooldownTicks, int cooldownDelayTicks) {
        this.cooldown = new Cooldown(cooldownTicks, cooldownTicks, cooldownDelayTicks);
    }

    public void reduceCooldownBy(int reduceBy) {
        if (this.cooldown == null) {
            return;
        }
        int cooldownDelayTicks = Math.max(0, this.cooldown.getRemainingDelayTicks() - reduceBy);
        int reduceCooldownBy = reduceBy - this.cooldown.getRemainingDelayTicks();
        int cooldownTicks = reduceCooldownBy > 0 ? Math.max(0, this.cooldown.getRemainingTicks() - reduceCooldownBy) : this.cooldown.getRemainingTicks();
        this.cooldown = new Cooldown(this.cooldown.getMaxTicks(), cooldownTicks, cooldownDelayTicks);
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Deprecated
    public abstract String getAbilityGroupName();

    @Override
    public void onTick(SkillContext context) {
        if (this.cooldown != null) {
            this.cooldown.decrement();
            if (this.cooldown.remainingTicks <= 0) {
                this.cooldown = null;
            }
        }
        if (!this.isUnlocked()) {
            this.setActive(false);
            return;
        }
        if (this.isActive()) {
            TickResult result = this.doActiveTick(context);
            if (result == TickResult.COOLDOWN) {
                this.putOnCooldown(context);
            }
        } else {
            TickResult result = this.doInactiveTick(context);
            if (result == TickResult.COOLDOWN) {
                this.putOnCooldown(context);
            }
        }
    }

    public TickResult doActiveTick(SkillContext context) {
        return TickResult.PASS;
    }

    public TickResult doInactiveTick(SkillContext context) {
        return TickResult.PASS;
    }

    public boolean onKeyDown(SkillContext context) {
        return this.isUnlocked() && !this.isTreeOnCooldown();
    }

    public boolean onKeyUp(SkillContext context) {
        if (!this.isUnlocked() || this.isTreeOnCooldown()) {
            context.getSource().as(Entity.class).ifPresent(entity -> entity.f_19853_.m_6269_(null, entity, ModSounds.ABILITY_ON_COOLDOWN, SoundSource.PLAYERS, 1.0f, 1.0f));
            return false;
        }
        return true;
    }

    public boolean onCancelKeyDown(SkillContext context) {
        return this.isUnlocked() && !this.isTreeOnCooldown();
    }

    public void onFocus(SkillContext context) {
    }

    public void onBlur(SkillContext context) {
    }

    @Override
    public boolean isOnCooldown() {
        return this.cooldown != null && this.cooldown.remainingTicks > 0;
    }

    @Override
    public void putOnCooldown(int cooldownDelayTicks, SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresentOrElse(player -> this.setCooldown(CooldownHelper.adjustCooldown(player, this.getId(), this.cooldownTicks), cooldownDelayTicks), () -> this.setCooldown(this.cooldownTicks, cooldownDelayTicks));
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.INT.writeBits(this.cooldownTicks, buffer);
        Cooldown.ADAPTER.writeBits(this.cooldown, buffer);
        Adapters.BOOLEAN.writeBits(this.active, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.cooldownTicks = Adapters.INT.readBits(buffer).orElse(0);
        this.cooldown = Cooldown.ADAPTER.readBits(buffer).orElse(null);
        this.active = Adapters.BOOLEAN.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.INT.writeNbt(this.cooldownTicks).ifPresent(tag -> nbt.m_128365_("cooldownTicks", tag));
            Cooldown.ADAPTER.writeNbt(this.cooldown).ifPresent(tag -> nbt.m_128365_("cooldown", (Tag)tag));
            Adapters.BOOLEAN.writeNbt(this.active).ifPresent(tag -> nbt.m_128365_("active", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.cooldownTicks = Adapters.INT.readNbt(nbt.m_128423_("cooldownTicks")).orElse(0);
        this.cooldown = Cooldown.ADAPTER.readNbt((CompoundTag)nbt.m_128423_("cooldown")).orElse(null);
        this.active = Adapters.BOOLEAN.readNbt(nbt.m_128423_("active")).orElse(false);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.INT.writeJson(this.cooldownTicks).ifPresent(element -> json.add("cooldownTicks", element));
            Cooldown.ADAPTER.writeJson(this.cooldown).ifPresent(element -> json.add("cooldown", (JsonElement)element));
            Adapters.BOOLEAN.writeJson(this.active).ifPresent(element -> json.add("active", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.cooldownTicks = Adapters.INT.readJson(json.get("cooldownTicks")).orElse(0);
        this.cooldown = Cooldown.ADAPTER.readJson((JsonObject)json.get("cooldown")).orElse(null);
        this.active = Adapters.BOOLEAN.readJson(json.get("active")).orElse(false);
    }

    public static enum TickResult {
        PASS,
        COOLDOWN;

    }

    public static enum ActivityFlag {
        NO_OP,
        DEACTIVATE_ABILITY,
        ACTIVATE_ABILITY;

    }

    public static class ActionResult {
        private static final ActionResult FAIL = new ActionResult(State.FAIL, false, 0);
        private static final ActionResult SUCCESS_COOLDOWN_IMMEDIATE = new ActionResult(State.SUCCESS, true, 0);
        private static final ActionResult SUCCESS_COOLDOWN_DEFERRED = new ActionResult(State.SUCCESS, false, 0);
        private final State state;
        private final boolean startCooldown;
        private final int cooldownDelayTicks;

        private ActionResult(State state, boolean startCooldown, int cooldownDelayTicks) {
            this.state = state;
            this.startCooldown = startCooldown;
            this.cooldownDelayTicks = cooldownDelayTicks;
        }

        public boolean isSuccess() {
            return this.state == State.SUCCESS;
        }

        public boolean startCooldown() {
            return this.startCooldown;
        }

        public int getCooldownDelayTicks() {
            return this.cooldownDelayTicks;
        }

        public static ActionResult fail() {
            return FAIL;
        }

        public static ActionResult successCooldownImmediate() {
            return SUCCESS_COOLDOWN_IMMEDIATE;
        }

        public static ActionResult successCooldownDeferred() {
            return SUCCESS_COOLDOWN_DEFERRED;
        }

        public static ActionResult successCooldownDelayed(int cooldownDelayTicks) {
            return new ActionResult(State.SUCCESS, true, cooldownDelayTicks);
        }

        public static enum State {
            FAIL,
            SUCCESS;

        }
    }
}

