/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect.spi.core;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.basic.SerializableAdapter;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.item.crystal.data.serializable.ISerializable;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;

public class Cooldown
implements ISerializable<CompoundTag, JsonObject> {
    public static final SerializableAdapter<Cooldown, CompoundTag, JsonObject> ADAPTER = new SerializableAdapter(Cooldown::new, true);
    public int maxTicks;
    public int remainingTicks;
    public int remainingDelayTicks;

    private Cooldown() {
    }

    public Cooldown(int maxTicks, int remainingTicks, int remainingDelayTicks) {
        this.maxTicks = maxTicks;
        this.remainingTicks = remainingTicks;
        this.remainingDelayTicks = remainingDelayTicks;
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public int getRemainingTicks() {
        return this.remainingTicks;
    }

    public int getRemainingDelayTicks() {
        return this.remainingDelayTicks;
    }

    public void decrement() {
        if (this.remainingDelayTicks > 0) {
            --this.remainingDelayTicks;
        } else {
            --this.remainingTicks;
        }
    }

    public boolean isLargerThan(Cooldown other) {
        return this.remainingTicks + this.remainingDelayTicks > other.remainingTicks + other.remainingDelayTicks;
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        Adapters.INT_SEGMENTED_7.writeBits(this.maxTicks, buffer);
        Adapters.INT_SEGMENTED_7.writeBits(this.remainingTicks, buffer);
        Adapters.INT_SEGMENTED_7.writeBits(this.remainingDelayTicks, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        this.maxTicks = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
        this.remainingTicks = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
        this.remainingDelayTicks = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        CompoundTag nbt = new CompoundTag();
        Adapters.INT.writeNbt(this.maxTicks).ifPresent(tag -> nbt.m_128365_("maxTicks", tag));
        Adapters.INT.writeNbt(this.remainingTicks).ifPresent(tag -> nbt.m_128365_("remainingTicks", tag));
        Adapters.INT.writeNbt(this.remainingDelayTicks).ifPresent(tag -> nbt.m_128365_("remainingDelayTicks", tag));
        return Optional.of(nbt);
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        this.maxTicks = Adapters.INT.readNbt(nbt.m_128423_("maxTicks")).orElse(0);
        this.remainingTicks = Adapters.INT.readNbt(nbt.m_128423_("remainingTicks")).orElse(0);
        this.remainingDelayTicks = Adapters.INT.readNbt(nbt.m_128423_("remainingDelayTicks")).orElse(0);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        JsonObject json = new JsonObject();
        Adapters.INT.writeJson(this.maxTicks).ifPresent(element -> json.add("maxTicks", element));
        Adapters.INT.writeJson(this.remainingTicks).ifPresent(element -> json.add("remainingTicks", element));
        Adapters.INT.writeJson(this.remainingDelayTicks).ifPresent(element -> json.add("remainingDelayTicks", element));
        return Optional.of(json);
    }

    @Override
    public void readJson(JsonObject json) {
        this.maxTicks = Adapters.INT.readJson(json.get("maxTicks")).orElse(0);
        this.remainingTicks = Adapters.INT.readJson(json.get("remainingTicks")).orElse(0);
        this.remainingDelayTicks = Adapters.INT.readJson(json.get("remainingDelayTicks")).orElse(0);
    }
}

