/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect.spi.core;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.init.ModSounds;
import iskallia.vault.skill.ability.effect.spi.core.IInstantManaAbility;
import iskallia.vault.skill.ability.effect.spi.core.InstantAbility;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.util.calc.ManaCostHelper;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;

public abstract class InstantManaAbility
extends InstantAbility
implements IInstantManaAbility {
    private float manaCost;

    public InstantManaAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks);
        this.manaCost = manaCost;
    }

    protected InstantManaAbility() {
    }

    @Override
    public float getManaCost() {
        return this.manaCost;
    }

    @Override
    protected boolean canDoAction(SkillContext context) {
        return context.getSource().getMana().map(mana -> {
            float cost = this.manaCost;
            if (mana instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)mana;
                if (player.m_7500_()) {
                    return true;
                }
                cost = ManaCostHelper.adjustManaCost(player, this.getAbilityGroupName(), cost);
                if (mana.getMana() < cost) {
                    player.f_19853_.m_6269_(null, (Entity)player, ModSounds.ABILITY_OUT_OF_MANA, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
            return mana.getMana() >= cost;
        }).orElse(false);
    }

    @Override
    protected void doActionPost(SkillContext context) {
        context.getSource().getMana().ifPresent(mana -> {
            float cost = this.manaCost;
            if (mana instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)mana;
                if (player.m_7500_()) {
                    return;
                }
                cost = ManaCostHelper.adjustManaCost(player, this.getAbilityGroupName(), cost);
            }
            mana.decreaseMana(cost);
        });
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.manaCost), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.manaCost = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.manaCost)).ifPresent(tag -> nbt.m_128365_("manaCost", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.manaCost = Adapters.FLOAT.readNbt(nbt.m_128423_("manaCost")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.manaCost)).ifPresent(element -> json.add("manaCost", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.manaCost = Adapters.FLOAT.readJson(json.get("manaCost")).orElse(Float.valueOf(0.0f)).floatValue();
    }
}

