/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect.spi.core;

import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.base.SkillContext;

public abstract class ToggleAbility
extends Ability {
    public ToggleAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks);
    }

    protected ToggleAbility() {
    }

    @Override
    public boolean onKeyUp(SkillContext context) {
        if (!super.onKeyUp(context)) {
            return false;
        }
        this.setActive(!this.isActive());
        Ability.ActionResult result = this.onAction(context);
        if (result.startCooldown()) {
            this.putOnCooldown(result.getCooldownDelayTicks(), context);
        }
        return true;
    }

    public Ability.ActionResult onAction(SkillContext context) {
        Ability.ActionResult result;
        if (this.canToggle(context)) {
            result = this.doToggle(context);
            if (result.isSuccess()) {
                this.doToggleParticles(context);
                this.doToggleSound(context);
            }
        } else {
            result = Ability.ActionResult.fail();
        }
        return result;
    }

    protected boolean canToggle(SkillContext context) {
        return true;
    }

    protected Ability.ActionResult doToggle(SkillContext context) {
        if (this.isActive()) {
            return Ability.ActionResult.successCooldownDeferred();
        }
        return Ability.ActionResult.successCooldownImmediate();
    }

    protected void doToggleParticles(SkillContext context) {
    }

    protected void doToggleSound(SkillContext context) {
    }
}

